/*
 * Copyright (C) 2004 Stephan Mres <Erdling@gmx.net>
 */

#ifndef _PLUGIN_KATESNIPPETS_H_
#define _PLUGIN_KATESNIPPETS_H_

#include <kate/application.h>
#include <kate/documentmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>
#include <kmdi/toolviewaccessor.h>
#include <klibloader.h>
#include <klocale.h>

#include <kdockwidget.h>
#include <kate/toolviewmanager.h>
#include "cwidgetsnippets.h"

#include <qlistview.h>
#include <qregexp.h>
#include <kconfig.h>
#include "csnippet.h"
#include <qptrlist.h>
#include <qtoolbutton.h>
#include <qtextedit.h>
#include <kiconloader.h>
#include <qsignalmapper.h>

class CSnippet;
//class PluginView;

class KatePluginFactory : public KLibFactory
{
  Q_OBJECT

  public:
    KatePluginFactory();
    virtual ~KatePluginFactory();

    virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

  private:
    static KInstance* s_instance;
};

class KatePluginKateSnippets : public Kate::Plugin, Kate::PluginViewInterface
{
  Q_OBJECT

  public:
    KatePluginKateSnippets( QObject* parent = 0, const char* name = 0 );
    virtual ~KatePluginKateSnippets();

    void addView (Kate::MainWindow *win);
    void removeView (Kate::MainWindow *win);
	CSnippet* findSnippetByListViewItem(QListViewItem *item);
//	PluginView* getFirstView();

  public slots:
    void slotInsertHello();
	void slot_lvSnippetsSelectionChanged(QListViewItem  * item);
	void slot_lvSnippetsClicked (QListViewItem * item);
	void slot_lvSnippetsItemRenamed(QListViewItem *lvi,int col, const QString& text);
	void slot_btnNewClicked();
	void slot_btnSaveClicked();
	void slot_btnDeleteClicked();
  private:
    QPtrList<class PluginView> m_views;
	QSignalMapper *snippetActionMapper;
	KConfig *config;
//	KMdiToolViewAccessor* tvaSnippets;
	KMDI::ToolViewAccessor* tvaSnippets;
	CWidgetSnippets *widgetSnippets;
	QPtrList<CSnippet> lSnippets;
  protected:
	void readConfig();
	void writeConfig();

};

#endif // _PLUGIN_KATESNIPPETS_H_
