/****************************************************************************
** $Id: PictureDisplay.java,v 1.2 2002/03/10 16:08:02 rdale Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

import org.kde.qt.*;

class PictureDisplay extends QWidget		// picture display widget
{

static void paintCar( QPainter p )			// paint a car
{
    QPointArray a = new QPointArray();
    QBrush brush = new QBrush( Qt.yellow(), Qt.SolidPattern );
    p.setBrush( brush );			// use solid, yellow brush

    a.setPoints( 5, new short[] { 50,50, 350,50, 450,120, 450,250, 50,250 } );
    p.drawPolygon( a );			// draw car body

    QFont f = new QFont( "courier", 12, QFont.Bold, false );
    p.setFont( f );

    QColor windowColor = new QColor( 120, 120, 255 );	// a light blue color
    brush.setColor( windowColor );		// set this brush color
    p.setBrush( brush );			// set brush
    p.drawRect( 80, 80, 250, 70 );		// car window
    p.drawText( 180, 80, 150, 70, Qt.AlignCenter, "--  Qt  --\nTrolltech AS" );

    QPixmap pixmap = new QPixmap();
    if ( pixmap.load("flag.bmp") )		// load and draw image
	p.drawPixmap( 100, 90, pixmap );

    p.setBackgroundMode( Qt.OpaqueMode );		// set opaque mode
    p.setBrush( Qt.DiagCrossPattern );		// black diagonal cross pattern
    p.drawEllipse( 90, 210, 80, 80 );		// back wheel
    p.setBrush( Qt.CrossPattern );		// black cross fill pattern
    p.drawEllipse( 310, 210, 80, 80 );		// front wheel
}



private QPicture   pict;
private String	name;

public PictureDisplay( String fileName )
{
    pict = new QPicture();
    name = fileName;
    if ( !pict.load(fileName) ) {		// cannot load picture
	pict = null;
	name = "Not able to load picture: " + fileName;
    }
}

protected void paintEvent( QPaintEvent event )
{
    QPainter paint = new QPainter( this );			// paint widget
    if ( pict != null )
    	paint.drawPicture( pict );		// draw picture
    else
	paint.drawText( rect(), AlignCenter, name );
}

protected void keyPressEvent( QKeyEvent k )
{
//   switch ( tolower(k.ascii()) ) {
    switch ( k.ascii() ) {
	case 'r':				// reload
	    pict.load( name );
	    update();
	    break;
	case 'q':				// quit
	    QApplication.exit();
	    break;
    }
}


static public void main( String[] args )
{
    QApplication a = new QApplication( args );		// QApplication required!

    String fileName = "car.pic";			// default picture file name

    if ( args.length == 1 )				// use argument as file name
	fileName = args[0];

    if ( !QFile.exists(fileName) ) {
	QPicture pict = new QPicture();				// our picture
	QPainter paint = new QPainter();				// our painter

	paint.begin( pict );			// begin painting onto picture
	paintCar( paint );				// paint!
	paint.end();				// painting done

	pict.save( fileName );			// save picture
	QMessageBox.information(null, "Qt picture example", "Saved.  Run me again!");
	return;
    } else {
	PictureDisplay test = new PictureDisplay( fileName );		// create picture display
	a.setMainWidget( test);			// set main widget
	test.show();				// show it

	a.exec();				// start event loop
	return;
    }
}

static {
	qtjava.initialize();
}

}

