//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QPixmap;

/**

 Convenience access to certain properties and features of the
 window manager.
 This class is not supposed to be instantiated.  It exists mostly as
 a namespace for the static member functions.
 In KDE 2 and KDE 3, communication with the windowmanager is done with the
 NET-protocol, a common window manager specification designed by
 various authors of X11 window managers (including those of the KDE
 project).  The full specification can be found at
 www.freedesktop.org/standards/wm-spec .
 To access features of the NET-protocol, use the classes NETRootInfo
 and NETWinInfo.
 The purpose of this class is to to provide easy access to the
 most-commonly used NET-features with a simpler, KDEish interface.
 In addition, it encapsulates KDE functionality not yet provided by
 the NET hints.  Currently that is invokeContextHelp() and
 setSystemTrayWindowFor() only.
		@author Matthias Ettrich (ettrich@kde.org)

		@short Class for interaction with the window manager. 
		@see NET
		@see NetWinInfo

*/
public class KWin implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KWin(Class dummy){}

	/**	
		 Masks specifying from which sources to read an icon. They are tried from the best
		 until an icon is found.
		
			<li>
			NETWM from property from the window manager specification
			</li>
			
			<li>
			WMHints from WMHints property
			</li>
			
			<li>
			ClassHint load icon after getting name from the classhint
			</li>
			
			<li>
			XApp load the standard X icon (last fallback)
			     
			</li>		@short    Masks specifying from which sources to read an icon.
	*/
	public static final int NETWM = 1;
	public static final int WMHints = 2;
	public static final int ClassHint = 4;
	public static final int XApp = 8;

	public KWin() {
		newKWin();
	}
	private native void newKWin();
	/**	
		 Requests that window <code>is</code> activated.
			 There are two ways how to activate a window, by calling
		 activateWindow() and forceActiveWindow(). Generally,
		 applications shouldn't make attempts to explicitly activate
		 their windows, and instead let the user to activate them.
		 In the special cases where this may be needed, applications
		 should use activateWindow(). Window manager may consider whether
		 this request wouldn't result in focus stealing, which
		 would be obtrusive, and may refuse the request.
			 The usage of forceActiveWindow() is meant only for pagers
		 and similar tools, which represent direct user actions
		 related to window manipulation.
		 Except for rare cases, this request will be always honored,
		 and normal applications are forbidden to use it.
			 In case of problems, consult the KWin README in the kdebase
		 package (kdebase/kwin/README), or ask on the kwin@kde.org
		 mailing list.
			@param win the if of the window to make active
			@param time X server timestamp of the user activity that
		    caused this request
				@short    Requests that window <code>is</code> activated.
	*/
	public static native void activateWindow(long win, long time);
	public static native void activateWindow(long win);
	/**	
		 Sets window <code>win</code> to be the active window. Note that this
		 should be called only in special cases, applications
		 shouldn't force themselves or other windows to be the active
		 window. Generally, this call should used only by pagers
		 and similar tools. See the explanation in description
		 of activateWindow().
			@param win the if of the window to make active
			@param time X server timestamp of the user activity that
		    caused this request
				@short    Sets window <code>win</code> to be the active window.
	*/
	public static native void forceActiveWindow(long win, long time);
	public static native void forceActiveWindow(long win);
	/**	
		 When application finishes some operation and wants to notify
		 the user about it, it can call demandAttention(). Instead
		 of activating the window, which could be obtrusive, the window
		 will be marked specially as demanding user's attention.
		 See also explanation in description of activateWindow().
			 Note that it's usually better to use KNotifyClient.
				@short    When application finishes some operation and wants to notify  the user about it, it can call demandAttention().
	*/
	public static native void demandAttention(long win, boolean set);
	public static native void demandAttention(long win);
	/**	
		 Sets user timestamp <code>time</code> on window <code>win.</code> The timestamp
		 is expressed as XServer time. If a window
		 is shown with user timestamp older than the time of the last
		 user action, it won't be activated after being shown.
		 The most common case is the special value 0 which means
		 not to activate the window after being shown.
				@short    Sets user timestamp <code>time</code> on window <code>win.</code>
	*/
	public static native void setUserTime(long win, long time);
	/**	
		 Invokes interactive context help.
		     		@short    Invokes interactive context help.
	*/
	public static native void invokeContextHelp();
	/**	
		 Makes <code>trayWin</code> a system tray window for <code>forWin.</code>
			 A system tray window serves as an icon replacement. It's
		 displayed inside the panel's system tray.
			@param trayWin the id of the system tray window
			@param forWin the id of the window represented by the system
		        tray window
		     		@short    Makes <code>trayWin</code> a system tray window for <code>forWin.</code>
	*/
	public static native void setSystemTrayWindowFor(long trayWin, long forWin);
	/**	
		 Returns information about window <code>win.</code> It is recommended to check
		 whether the returned info is valid by calling the valid() method.
			@param win the id of the window
			@param properties all properties that should be retrieved (see NET.Property
		    enum for details) - passing 0 means all properties. Unlisted properties
		    cause related information to be invalid in the returned data, but
		    make this function faster when not all data is needed.
			@param properties2 additional properties (see NET.Property2 enum)
				@return the window information

		@short    Returns information about window <code>win.</code>
	*/
	// KWin::WindowInfo windowInfo(WId arg1,unsigned long arg2,unsigned long arg3); >>>> NOT CONVERTED
	// KWin::WindowInfo windowInfo(WId arg1,unsigned long arg2); >>>> NOT CONVERTED
	// KWin::WindowInfo windowInfo(WId arg1); >>>> NOT CONVERTED
	/**	
		 Returns the WM_TRANSIENT_FOR property for the given window, i.e. the mainwindow
		 for this window.
			@param window the id of the window
				@short    Returns the WM_TRANSIENT_FOR property for the given window, i.
	*/
	public static native long transientFor(long window);
	/**	
		 Returns the leader window for the group the given window is in, if any.
			@param window the id of the window
				@short    Returns the leader window for the group the given window is in, if any.
	*/
	public static native long groupLeader(long window);
	/**	
		 Returns an icon for window <code>win.</code>
			 If  <code>width</code> and <code>height</code> are specified, the best icon for the requested
		 size is returned.
			 If <code>scale</code> is true, the icon is smooth-scaled to have exactly
		 the requested size.
			@param win the id of the window
			@param width the desired width, or -1
			@param height the desired height, or -1
			@param scale if true the icon will be scaled to the desired size. Otherwise the
		        icon will not be modified.
				@return the icon of the window
     
		@short    Returns an icon for window <code>win.</code>
	*/
	public static native QPixmap icon(long win, int width, int height, boolean scale);
	public static native QPixmap icon(long win, int width, int height);
	public static native QPixmap icon(long win, int width);
	public static native QPixmap icon(long win);
	/**	
		 @overload
			 Overloaded variant that allows specifying from which sources the icon should be read.
		 You should usually prefer the simpler variant which tries all possibilities to get
		 an icon.
			@param win the id of the window
			@param width the desired width, or -1
			@param height the desired height, or -1
			@param scale if true the icon will be scaled to the desired size. Otherwise the
		        icon will not be modified.
			@param flags OR-ed flags from the IconSource enum
				@short    @overload
	*/
	public static native QPixmap icon(long win, int width, int height, boolean scale, int flags);
	/**	
		 Sets an <code>icon</code> and a  <code>miniIcon</code> on window <code>win</code>
			@param win the id of the window
			@param icon the new icon
			@param miniIcon the new mini icon
		     		@short    Sets an <code>icon</code> and a  <code>miniIcon</code> on window <code>win</code>
	*/
	public static native void setIcons(long win, QPixmap icon, QPixmap miniIcon);
	/**	
		 Sets the type of window <code>win</code> to <code>windowType.</code>
			 Possible values are NET.Normal, NET.Desktop, NET.Dock,
		 NET.Tool, NET.Menu, NET.Dialog, NET.Override (== no
		 decoration frame), NET.TopMenu, NET.Utility or NET.Splash
			@param win the id of the window
			@param windowType the type of the window
		     		@short    Sets the type of window <code>win</code> to <code>windowType.</code>
	*/
	public static native void setType(long win, int windowType);
	/**	
		 Sets the state of window <code>win</code> to <code>state.</code>
			 Possible values are or'ed combinations of NET.Modal,
		 NET.Sticky, NET.MaxVert, NET.MaxHoriz, NET.Shaded,
		 NET.SkipTaskbar, NET.SkipPager, NET.Hidden,
		 NET.FullScreen, NET.KeepAbove, NET.KeepBelow, NET.StaysOnTop
			@param win the id of the window
			@param state the new flags that will be set
		     		@short    Sets the state of window <code>win</code> to <code>state.</code>
	*/
	public static native void setState(long win, long state);
	/**	
		 Clears the state of window <code>win</code> from <code>state.</code>
			 Possible values are or'ed combinations of NET.Modal,
		 NET.Sticky, NET.MaxVert, NET.MaxHoriz, NET.Shaded,
		 NET.SkipTaskbar, NET.SkipPager, NET.Hidden,
		 NET.FullScreen, NET.KeepAbove, NET.KeepBelow, NET.StaysOnTop
			@param win the id of the window
			@param state the flags that will be cleared
		     		@short    Clears the state of window <code>win</code> from <code>state.</code>
	*/
	public static native void clearState(long win, long state);
	/**	
		 Sets window <code>win</code> to be present on all desktops if <code>is</code> true. Otherwise the window lives only on one single desktop.
			@param win the id of the window
			@param b true to show the window on all desktops, false
		          otherwise
		     		@short    Sets window <code>win</code> to be present on all virtual desktops if <code>is</code> true.
	*/
	public static native void setOnAllDesktops(long win, boolean b);
	/**	
		 Moves window <code>win</code> to desktop <code>desktop.</code>
			@param win the id of the window
			@param desktop the number of the new desktop
		     		@short    Moves window <code>win</code> to desktop <code>desktop.</code>
	*/
	public static native void setOnDesktop(long win, int desktop);
	/**	
		 Sets the strut of window <code>win</code> to <code>to</code> <code>left</code> width
		 ranging from <code>left_start</code> to <code>left_end</code> on the left edge,
		 and simiarly for the other edges. For not reserving a strut, pass 0 as the width.
		 E.g. to reserve 10x10 square in the topleft corner, use e.g.
		 setExtendedStrut( w, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0 ).
			@param win the id of the window
			@param left_width width of the strut at the left edge
			@param left_start starting y coordinate of the strut at the left edge
			@param left_end ending y coordinate of the strut at the left edge
			@param right_width width of the strut at the right edge
			@param right_start starting y coordinate of the strut at the right edge
			@param right_end ending y coordinate of the strut at the right edge
			@param top_width width of the strut at the top edge
			@param top_start starting x coordinate of the strut at the top edge
			@param top_end ending x coordinate of the strut at the top edge
			@param bottom_width width of the strut at the bottom edge
			@param bottom_start starting x coordinate of the strut at the bottom edge
			@param bottom_end ending x coordinate of the strut at the bottom edge
		     		@short    Sets the strut of window <code>win</code> to <code>to</code> <code>left</code> width  ranging from <code>left_start</code> to <code>left_end</code> on the left edge,  and simiarly for the other edges.
	*/
	public static native void setExtendedStrut(long win, int left_width, int left_start, int left_end, int right_width, int right_start, int right_end, int top_width, int top_start, int top_end, int bottom_width, int bottom_start, int bottom_end);
	/**	
		 Convenience function to access the current desktop.  See NETRootInfo.
				@return the number of the current desktop
     
		@short    Convenience function to access the current desktop.
	*/
	public static native int currentDesktop();
	/**	
		 Convenience function to access the number of desktops. See
		 NETRootInfo.
				@return the number of desktops
     
		@short    Convenience function to access the number of desktops.
	*/
	public static native int numberOfDesktops();
	/**	
		 Convenience function to set the current desktop to <code>desktop.</code>
		 See NETRootInfo.
			@param desktop the number of the new desktop
		     		@short    Convenience function to set the current desktop to <code>desktop.</code>
	*/
	public static native void setCurrentDesktop(int desktop);
	/**	
		 Iconifies a window. Compatible to XIconifyWindow but has an
		 additional parameter <code>animation.</code>
			@param win the id of the window
			@param animation true to show an animation
				@short    Iconifies a window.
		@see #deIconifyWindow
	*/
	public static native void iconifyWindow(long win, boolean animation);
	public static native void iconifyWindow(long win);
	/**	
		 DeIconifies a window. Compatible to XMapWindow but has an
		 additional parameter <code>animation.</code>
			@param win the id of the window
			@param animation true to show an animation
				@short    DeIconifies a window.
		@see #iconifyWindow
	*/
	public static native void deIconifyWindow(long win, boolean animation);
	public static native void deIconifyWindow(long win);
	/**	
		 Raises the given window. This call is only for pagers and similar
		 tools that represent direct user actions. Applications should not
		 use it, they should keep using QWidget.raise() or XRaiseWindow()
		 if necessary.
				@short    Raises the given window.
	*/
	public static native void raiseWindow(long win);
	/**	
		 Lowers the given window. This call is only for pagers and similar
		 tools that represent direct user actions. Applications should not
		 use it, they should keep using QWidget.lower() or XLowerWindow()
		 if necessary.
				@short    Lowers the given window.
	*/
	public static native void lowerWindow(long win);
	/**	
			 Returns true if the WM uses IconicState also for windows
		 on inactive desktops.
		     		@short
	*/
	public static native boolean icccmCompliantMappingState();
	/**	
		 Returns true if the WM announces which actions it allows for windows.
				@short    Returns true if the WM announces which actions it allows for windows.
	*/
	public static native boolean allowedActionsSupported();
	/**	
		 Function that reads and returns the contents of the given text
		 property (WM_NAME, WM_ICON_NAME,...).
				@short    Function that reads and returns the contents of the given text  property (WM_NAME, WM_ICON_NAME,.
	*/
	public static native String readNameProperty(long window, long atom);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
