/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

#include "taskbarcontainer.h"

#include "taskbarextension.h"
#include "taskbarextension.moc"

extern "C"
{
    KPanelExtension* init( QWidget *parent, const QString& configFile )
    {
        KGlobal::locale()->insertCatalogue( "taskbarextension" );
   	return new TaskBarExtension( configFile, KPanelExtension::Stretch,
				     KPanelExtension::Preferences, parent, "taskbarextension" );
    }
}

TaskBarExtension::TaskBarExtension(const QString& configFile, Type type,
				   int actions, QWidget *parent, const char *name)
    : KPanelExtension(configFile, type, actions, parent, name)
{
    QHBoxLayout* layout = new QHBoxLayout( this );
    container = new TaskBarContainer( false, this );
    positionChange( position() );
    layout->addWidget( container );
    setSize(SizeSmall, customSize());

    connect( container, SIGNAL( containerCountChanged() ),
             this, SIGNAL( updateLayout() ) );
}

TaskBarExtension::~TaskBarExtension()
{
    KGlobal::locale()->removeCatalogue( "taskbarextension" );
}

void TaskBarExtension::positionChange( Position p )
{

    container->orientationChange( orientation() );

    // FIXME: Need a globally defined enum Direction
    switch( p ) {
    case Bottom:
	container->popupDirectionChange( KPanelApplet::Up );
	break;
    case Top:
	container->popupDirectionChange( KPanelApplet::Down );
	break;
    case Right:
	container->popupDirectionChange( KPanelApplet::Left );
	break;
    case Left:
	container->popupDirectionChange( KPanelApplet::Right );
	break;
    }

}

void TaskBarExtension::preferences()
{
    container->preferences();
}

QSize TaskBarExtension::sizeHint(Position p, QSize maxSize) const
{
    if (p == Left || p == Right)
        maxSize.setWidth(sizeInPixels());
    else
        maxSize.setHeight(sizeInPixels());

//    kdDebug(1210) << "TaskBarExtension::sizeHint( Position, QSize )" << endl;
//    kdDebug(1210) << " width: " << size.width() << endl;
//    kdDebug(1210) << "height: " << size.height() << endl;
    return container->sizeHint( p, maxSize );
}
