/* kasstartupitem.cpp
**
** Copyright (C) 2001-2004 Richard Moore <rich@kde.org>
** Contributor: Mosfet
**     All rights reserved.
**
** KasBar is dual-licensed: you can choose the GPL or the BSD license.
** Short forms of both licenses are included below.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/
#include <qpainter.h>
#include <qbitmap.h>
#include <qdrawutil.h>
#include <qtimer.h>

#include <kglobal.h>
#include <kwin.h>
#include <kiconloader.h>
#include <kpixmap.h>
#include <kpixmapeffect.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <taskmanager.h>

#include "kaspopup.h"
#include "kasstartupitem.h"

static const int MAX_ANIMATION_FRAME=10;

KasStartupItem::KasStartupItem( KasBar *parent, Startup *startup )
    : KasItem( parent ),
      startup_(startup), frame(0)
{
    setText( startup_->text() );
    pixmap = icon();

    //
    // Setup animation frames and timer.
    //
    anim.setAutoDelete( true );
    for ( int i = 1; i <= MAX_ANIMATION_FRAME; i++ )
        anim.append(new QPixmap(locate("data", "kicker/pics/disk" + QString::number(i) + ".png")));

    aniTimer = new QTimer( this );
    connect( aniTimer, SIGNAL( timeout() ),
             this, SLOT( aniTimerFired() ) );
    aniTimer->start( 100 );
}

KasStartupItem::~KasStartupItem()
{
    delete aniTimer;
}

QPixmap KasStartupItem::icon() const
{
   /**
    * This icon stuff should all be handled by the task manager api, but isn't yet.
    */
   QPixmap pixmap;

   switch( kasbar()->itemSize() ) {
   case KasBar::Small:
     /* ***** NOP ******
	pixmap = KGlobal::iconLoader()->loadIcon( startup_->icon(),
						  KIcon::NoGroup,
						  KIcon::SizeSmall );
     */
      break;
   case KasBar::Medium:
	pixmap = KGlobal::iconLoader()->loadIcon( startup_->icon(),
						  KIcon::NoGroup,
						  KIcon::SizeMedium );
      break;
   case KasBar::Large:
	pixmap = KGlobal::iconLoader()->loadIcon( startup_->icon(),
						  KIcon::NoGroup,
						  KIcon::SizeLarge );
      break;
   default:
	pixmap = KGlobal::iconLoader()->loadIcon( "error",
						  KIcon::NoGroup,
						  KIcon::SizeSmall );
   }

   return pixmap;
}

void KasStartupItem::aniTimerFired()
{
    if ( frame == MAX_ANIMATION_FRAME )
        frame = 0;
    else
        frame++;

    QPainter p( kasbar() );
    QPoint pos = kasbar()->itemPos( this );
    repaint( true );
    paintAnimation( &p, pos.x(), pos.y() );
}

void KasStartupItem::paintAnimation( QPainter *p, int x, int y )
{
  QPixmap *pix = anim.at(frame);
  if ( pix )
    p->drawPixmap( x+extent()-18, y+16, *pix );
}

void KasStartupItem::paint( QPainter *p )
{
    KasItem::paint( p );

    if ( kasbar()->itemSize() == KasBar::Small ) {
      //
      // Paint animation only for small mode.
      //
      QPixmap *pix = anim.at(frame);
      if ( pix )
        p->drawPixmap( 4, 16, *pix );

    }
    else {
      //
      // Draw icon
      //
      if ( !pixmap.isNull() )
	p->drawPixmap(4, 16, pixmap );

      paintAnimation( p );
    }
}

#include "kasstartupitem.moc"
