/*****************************************************************

Copyright (c) 1996-2003 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panelbuttonbase_h__
#define __panelbuttonbase_h__

#include <qbutton.h>
#include <qcolor.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kiconloader.h>
#include <kurl.h>
#include <algorithm>

#include "global.h"
class KConfigGroup;

class PanelButtonBase : public QButton
{
    Q_OBJECT

public:
    PanelButtonBase(QWidget *parent=0, const char *name=0,  WFlags f=0 );

    virtual void configure();

    bool isValid() const { return _valid; };
    void setTile(const QString&, const QColor& color = QColor());
    void setIcon(const QString&);
    void setIconURL(const KURL& url);
    void setTitle(const QString&);

    void setDrawArrow(bool);

    const QString& title() const { return _title; }
    const QString& icon() const { return _iconName; }
    Orientation orientation() const { return _orientation; }
    Direction popupDirection() const { return _popupDirection; }
    QPoint center() const { return mapToGlobal(rect().center()); }
    virtual const QPixmap& labelIcon() const;
    virtual const QPixmap& zoomIcon() const { return _iconz; }

    static void setZoomEnabled(bool b);
    void setBackground();

    bool conserveSpace() const;
    int maxButtonDim() const;
    int maxIconDim() const;
    int iconMargin(int iconDim) const;
    virtual int preferredDimension(int panelDim) const;

signals:
    void iconChanged();

public slots:
    void slotSetOrientation(Orientation o) { _orientation = o; }
    void slotSetPopupDirection(Direction d);
    void slotMovieUpdate(const QRect&);
    void slotMovieStatus(int);

protected slots:
    void slotSettingsChanged(int);

protected:
    virtual void resizeEvent(QResizeEvent*);
    virtual void drawButton(QPainter *);
    virtual void drawButtonLabel(QPainter *);
    virtual void enterEvent(QEvent *);
    virtual void leaveEvent(QEvent *);
    virtual void dragEnterEvent(QDragEnterEvent *);
    virtual void dragLeaveEvent(QDragLeaveEvent *);
    virtual void dropEvent(QDropEvent *);

    virtual std::pair<int,int> preferredIconSizes(int proposed_size=-1) const;
    virtual QString defaultIcon() const { return "unknown"; };

    void setArrowDirection(Position dir);
    void loadTiles();
    void loadIcons();
    bool calculateIconSizes();

    bool _valid;
    QPixmap _icon;

private:
    bool _drawArrow;
    bool _highlight;
    bool _animated;
    bool _changeCursorOverItem;
    bool _hasAcceptedDrag;
    bool _hasAnimation;
    QString _tile;
    QString _title;
    QString _iconName;
    QPixmap _up;
    QPixmap _down;
    QPixmap _bg;
    QPixmap _iconh;
    QPixmap _iconz;
    QMovie *_movie;
    Position _arrowDirection;
    Direction _popupDirection;
    Orientation _orientation;
    int _size;
    int _zoom_size;
    QColor _tileColor;
};

QImage loadTile(const QString& name, const QSize&,
                const QString& state = QString::null);


#endif // __panelbuttonbase_h__

