#include "bindings.h"
#include "plugin_katekjswrapper.h"
#include <qstringlist.h>
#include <kdebug.h>
#include <kate/documentmanager.h>
#include <kate/document.h>
#include <kjsembed/kjsembedpart.h>
#include <kjsembed/jsfactory.h>
#include <klocale.h>
#include <kjs/value.h>
#include <kdockwidget.h>

using namespace Kate::JS;
Bindings::Bindings(QObject *parent): KJSEmbed::Bindings::JSBindingPlugin(parent,"KateAppBindings",QStringList()) {
}

Bindings::~Bindings() {
}

KJS::Object Bindings::createBinding(KJSEmbed::KJSEmbedPart *jspart, KJS::ExecState *exec, const KJS::List &args) const {
/*
        kdDebug() << "Loading a custom object" << endl;
        DocumentManager *obj = new DocumentManager();
        JSOpaqueProxy *prx = new JSOpaqueProxy(  (void *) obj, "Kate::JS::DocumentManager" );

        KJS::Object proxyObj(prx);
        DocumentManagerImp::addBindings( exec, proxyObj );
        return proxyObj;
*/
	return KJS::Object();
}


void Bindings::addBindings(KJS::ExecState *exec, KJS::Object &target) const {
	kdDebug()<<"Kate::JS::Bindings:: ADDING CUSTOM BINDINGS"<<endl;

	KJSEmbed::JSObjectProxy *proxy = KJSEmbed::JSProxy::toObjectProxy( target.imp() );
	if ( !proxy )
		return;
	
	Kate::DocumentManager *dm=dynamic_cast<Kate::DocumentManager*>(proxy->object());
	if (dm) {
		DocumentManager::addBindings(exec,proxy,target);
		return;
	}  else {
		Kate::Application *app=dynamic_cast<Kate::Application*>(proxy->object());
		Application::addBindings(exec,proxy,target);
	}
}

void DocumentManager::addBindings(KJS::ExecState *exec, KJSEmbed::JSObjectProxy *proxy,KJS::Object &object){
        object.put(exec, "document", KJS::Object(new DocumentManager( exec, Document, proxy )));
        object.put(exec, "activeDocument", KJS::Object(new DocumentManager( exec, ActiveDocument, proxy )));
        object.put(exec, "documentWithID", KJS::Object(new DocumentManager( exec, DocumentWithID, proxy )));
        object.put(exec, "findDocument", KJS::Object(new DocumentManager( exec, FindDocument, proxy )));
        object.put(exec, "openURL", KJS::Object(new DocumentManager( exec, OpenURL, proxy )));
        object.put(exec, "isOpen", KJS::Object(new DocumentManager( exec, IsOpen, proxy )));
        object.put(exec, "documents", KJS::Object(new DocumentManager( exec, Documents, proxy )));
        object.put(exec, "closeDocument", KJS::Object(new DocumentManager( exec, CloseDocument, proxy )));
        object.put(exec, "closeAllDocument", KJS::Object(new DocumentManager( exec, CloseAllDocuments, proxy )));
}

DocumentManager::DocumentManager( KJS::ExecState *exec, int id, KJSEmbed::JSObjectProxy *parent ):KJSEmbed::JSProxyImp(exec) {
	m_id=id;
	m_proxy=parent;
}


KJS::Value DocumentManager::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args ) {
	QObject *o=m_proxy->object();
	Kate::DocumentManager *dm=dynamic_cast<Kate::DocumentManager*>(o);
	if (!dm) {
		kdWarning()<<"Object died"<<endl;
	        QString msg = i18n("Call of DocumentManager member on destroyed object");
        	KJS::Object err = KJS::Error::create( exec, KJS::GeneralError, msg.utf8() );
	        exec->setException( err );
		return KJS::Undefined();
	}
	QString mdesc;
	switch (m_id) {
		case Document: {
			mdesc="document(int)";
			if (args.size()!=1) break;
			uint index=args[0].toUInt32(exec);
			if (exec->hadException()) break;
				QObject *doc=dynamic_cast<QObject*>(dm->document(index));
				if (!doc) return KJS::Null();
				return m_proxy->part()->factory()->createProxy(exec,doc,m_proxy); }
		break;
		case ActiveDocument: {
			mdesc="activeDocument()";
			if (args.size()!=0) break;
			QObject *doc=dynamic_cast<QObject*>(dm->activeDocument());
			if (!doc) return KJS::Null();
			return m_proxy->part()->factory()->createProxy(exec,doc,m_proxy); }
		break;
		case DocumentWithID: {
			mdesc="documentWithID(int)";
			if (args.size()!=1) break;
			uint id=args[0].toUInt32(exec);
			if (exec->hadException()) break;
				QObject *doc=dynamic_cast<QObject*>(dm->documentWithID(id));
				if (!doc) return KJS::Null();
				return m_proxy->part()->factory()->createProxy(exec,doc,m_proxy); }
		break;
		case FindDocument: {
			mdesc="findDocument(KURL)";
			if (args.size()!=1) break;
			KURL url = QString( args[0].toString(exec).qstring() );
			if (exec->hadException()) break;
				return KJS::Number(dm->findDocument(url)); }
		break;
		case IsOpen: {
			mdesc="isOpen(KURL)";
			if (args.size()!=0) break;
			KURL url = QString( args[0].toString(exec).qstring() );
			if (exec->hadException()) break;
				return KJS::Boolean(dm->isOpen(url));}

		break;
		case OpenURL: {
			mdesc="openURL(KURL[,String encoding])";
				uint docID;
				if (args.size()==1) {
					KURL url = QString( args[0].toString(exec).qstring() );
					if (exec->hadException()) break;
					(void)dm->openURL(url,QString::null,&docID);
					return KJS::Number(docID);
				} else if (args.size()==2) {
					KURL url = QString( args[0].toString(exec).qstring() );
					if (exec->hadException()) break;
					QString encoding=QString( args[1].toString(exec).qstring() );
					(void)dm->openURL(url,encoding,&docID);
					return KJS::Number(docID);
				}
			}
		break;
		case Documents: {
			mdesc="documents()";
			if (args.size()!=0) break;
			return KJS::Number(dm->documents()); }
		break;
		case CloseDocument: {
			mdesc="closeDocument(Kate::Document)";
			if (args.size()!=1) break;
			KJSEmbed::JSObjectProxy *proxy = KJSEmbed::JSProxy::toObjectProxy( args[0].imp() );
			if (!proxy) break;
			QObject *tmp=proxy->object();
			Kate::Document *tmpdoc=dynamic_cast<Kate::Document*>(tmp);
			if (!tmpdoc) break;
			return KJS::Boolean(dm->closeDocument(tmpdoc)); }
		break;
		case CloseAllDocuments: {
			mdesc="closeAllDocuments()";
			if (args.size()!=0) break;
			return KJS::Boolean(dm->closeAllDocuments()); }
		break;
		default:
		kdDebug()<<"calling illegal method of DocumentManager"<<endl;
		return KJS::Null(); 
	}
            QString msg = i18n("Method %1 called with wrong signature").arg(mdesc);
            KJS::Object err = KJS::Error::create( exec, KJS::GeneralError, msg.utf8() );
            exec->setException( err );
	    return KJS::Undefined();
	
}

Kate::JS::Management::Management(KJS::ExecState *exec, int id, PluginKateKJSWrapper *kateplug):KJSEmbed::JSProxyImp(exec) {
	m_id=id;
	m_wrapper=kateplug;
}


KJS::Value Kate::JS::Management::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args ) {
	if (m_id==AddConfigPage) {
		if (args.size()!=1) {
        	    QString msg = i18n("One parameter expected");
	            KJS::Object err = KJS::Error::create( exec, KJS::GeneralError, msg.utf8() );
        	    exec->setException( err );
		    return KJS::Undefined();
		}
		KJS::Value v=args[0];
		m_wrapper->m_configPageFactories.append(v);
	}
	else if (m_id==SetWindowConfiguration) {
		if (args.size()>3) {
        	    QString msg = i18n("A maximum of three parameters expected");
	            KJS::Object err = KJS::Error::create( exec, KJS::GeneralError, msg.utf8() );
        	    exec->setException( err );
		    return KJS::Undefined();
		}
		m_wrapper->m_toolViewConstructors=(args.size()>0)?args[0]:KJS::Value();
	        m_wrapper->m_newWindowHandler=(args.size()>1)?args[1]:KJS::Value();
        	m_wrapper->m_removeWindowHandler=(args.size()>2)?args[2]:KJS::Value();
	} else
		kdDebug()<<"Remove not implemented yet"<<endl;
	return KJS::Boolean(true);
}

void Kate::JS::Application::addBindings(KJS::ExecState *exec, KJSEmbed::JSObjectProxy *proxy,KJS::Object &object){
        KJS::Object ToolView(new Application( exec, ToolView, proxy ));
	ToolView.put(exec,KJS::Identifier("Left"),KJS::Number(KDockWidget::DockLeft) ,KJS::ReadOnly | KJS::DontDelete);
	ToolView.put(exec,KJS::Identifier("Top"),KJS::Number(KDockWidget::DockTop) ,KJS::ReadOnly | KJS::DontDelete);
	ToolView.put(exec,KJS::Identifier("Right"),KJS::Number(KDockWidget::DockRight) ,KJS::ReadOnly | KJS::DontDelete);
	ToolView.put(exec,KJS::Identifier("Bottom"),KJS::Number(KDockWidget::DockBottom), KJS::ReadOnly | KJS::DontDelete);	
	object.put(exec, "ToolView",ToolView);
}

Kate::JS::Application::Application( KJS::ExecState *exec, int id, KJSEmbed::JSObjectProxy *parent ):KJSEmbed::JSProxyImp(exec) {
	kdDebug()<<"Kate::JS::Application::Application"<<endl;
	m_id=id;
	m_proxy=parent;
}


KJS::Value Kate::JS::Application::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args ) {
}
