/*
 * Copyright (C) 2002-2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <regex.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_node_contents.h"
#include "add_file.h"
#include "callbacks.h"
#include "dummies.h"
#include "entry.h"
#include "icons.h"
#include "gdir.h"
#include "ls.h"
#include "misc.h"
#include "monitor.h"


extern int stop;

/* folders are open nodes. When they are closed they return
 * to plain file clasification */
void erase_children(GtkTreeModel * treemodel, GtkTreeIter * target)
{
    GtkTreeIter iter;
    tree_entry_t *en;



    while(gtk_tree_model_iter_children(treemodel, &iter, target))
    {
	erase_children(treemodel, &iter);

	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	destroy_entry(en);

	gtk_tree_store_remove((GtkTreeStore *) treemodel, &(iter));
    }
    return;
}

#if 0
void erase_children(GtkTreeView * treeview, GtkTreeIter * target)
{
    GtkTreeIter child;
    GList *tmp, *list = NULL;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    if(!gtk_tree_model_iter_children(treemodel, &child, target))
	return;
    do
    {
	GtkTreeRowReference *ref;
	GtkTreePath *tpath;
	tpath = gtk_tree_model_get_path(treemodel, &child);
	ref = gtk_tree_row_reference_new(treemodel, tpath);
	list = g_list_append(list, ref);
	gtk_tree_path_free(tpath);

    }
    while(gtk_tree_model_iter_next(treemodel, &child));
    for(tmp = list; tmp; tmp = tmp->next)
    {
	remove_it(treeview, (GtkTreeRowReference *) tmp->data);
	gtk_tree_row_reference_free((GtkTreeRowReference *) tmp->data);
    }
    g_list_free(list);

    return;
}
#endif

void remove_folder(GtkTreeView * treeview, GtkTreeIter * iter)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en = get_entry(treeview, iter);
    GtkTreeIter parent;
    tree_details_t *tree_details = get_tree_details(treeview);

    if(!tree_details->window)
	return;

    /*cursor_wait(treeview); */

    UNSET_LOADED(en->type);
    UNSET_INCOMPLETE(en->type);

    erase_children(treemodel, iter);
    add_dummy(treeview, iter);
    if(gtk_tree_model_iter_parent(treemodel, &parent, iter))
    {
	en = get_entry(treeview, &parent);
	if (!en || !en->tag) return;

	if (strchr(en->tag,'%'))
		print_status_tmp(treeview, resolve_icon_small(en),
			       	FILENAME(en), NULL);
	else
	    	print_status(treeview, resolve_folder_icon(en), en->tag, NULL);
    }

    /*while (gtk_events_pending())gtk_main_iteration();*/
    /*cursor_reset(treeview); */
}

void add_node_contents(GtkTreeView * treeview, GtkTreeIter * iter, gdir_t * gdir)
{

    tree_entry_t *en;
    unsigned int smallcount = 0;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    long long unsigned tama;
    GtkTreeIter iterator;
    int j = 0;

    if(!tree_details->window)
	return;

    if(!gdir)
	g_assert_not_reached();

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en)
	g_assert_not_reached();

    tama = 0;


    gtk_widget_freeze_child_notify((GtkWidget *) treeview);


    /* do a quicksort */
    update_dummy(treeview, iter, -2, -2);

    if (!IS_APP_TYPE(en->type)) {
	gdir_sort_type(en->type);
        qsort((void *)gdir->gl, gdir->pathc, sizeof(dir_t), gdir_compare);
    }
    if(!tree_details->window)
	return;

    show_stop(tree_details->window);
    /* load to treemodel */
    for(j = 0; j < gdir->pathc; j++)
    {
	if(tree_details->preferences & HIDE_WASTE_B && strcmp(gdir->gl[j].pathv, "..Wastebasket") == 0)
	    continue;

	if(!IS_TRASH_TYPE(gdir->gl[j].en->type) || (IS_TRASH_TYPE(gdir->gl[j].en->type) && !IS_XF_DIR(gdir->gl[j].en->type)))
	{
	    iterator = add_file(treeview, iter, gdir->gl[j].en, gdir->gl[j].pathv);
	}
/*
      else
	printf ("DBG: not adding %s type=0x%x trash=%d\n", gdir->gl[j].pathv,
		gdir->gl[j].en->type, IS_TRASH_TYPE (gdir->gl[j].en->type));
*/
	if(smallcount++ & (1 << 7))
	{
	    set_progress(treeview, j, gdir->pathc);
	    update_dummy(treeview, iter, j, 0);
	    smallcount = 1;
	}
	if(stop)
	{
	    update_dummy(treeview, iter, -3, 0);
	    goto aborted;
	}
	if(!tree_details->window)
	    return;
    }

    set_progress(treeview, j, gdir->pathc);
    update_dummy(treeview, iter, j, 0);

/*  printf("%s %d entries\n",en->path,j); */
    if(j)
    {
	if(IS_ROOT_TYPE(en->type) && IS_LOCAL_TYPE(en->type) && 
			en->path && strcmp(en->path, "/"))
	{
	    reset_dummy(treeview, iter, 5);
	}
	else {
	   if(gtk_tree_model_iter_n_children(treemodel,iter) > 1)
		erase_dummy(treeview, iter);
	   else reset_dummy(treeview, iter, 1);
	}
    }
    else reset_dummy(treeview, iter, 3);

    SET_LOADED(en->type);

  aborted:
    gtk_widget_thaw_child_notify((GtkWidget *) treeview);

    set_icon(treeview, iter);
    return;
}
