/***************************************************************************
* $Id: Scribble.java,v 1.4 2003/12/21 05:47:44 rdale Exp $
**
* Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.util.*;

class Scribble  extends QMainWindow
{

protected Canvas canvas;

protected QSpinBox bPWidth;
protected QToolButton bPColor, bSave, bClear;



class Canvas  extends QWidget
{

    void setPenColor( QColor c )
    { pen.setColor( c ); }

    void setPenWidth( int w )
    { pen.setWidth( w ); }

    QColor penColor()
    { return pen.color(); }

    int penWidth()
    { return pen.width(); }


protected QPen pen;
protected QPointArray polyline;

protected boolean mousePressed;

protected QPixmap buffer = new QPixmap();

public boolean no_writing = false;

Canvas( QWidget parent )
{
	this(parent, null);
}

Canvas( QWidget parent, String name )
{
    super( parent, name, WStaticContents );
	pen = new QPen( Qt.red(), 3 );
	polyline = new QPointArray(3);

    if ((qApp().args().length > 0) && !buffer.load(qApp().args()[0]))
	buffer.fill( colorGroup().base() );
    setBackgroundMode( QWidget.PaletteBase );
    setCursor( Qt.crossCursor() );
}

void save( String filename, String format )
{
    if ( !no_writing )
	buffer.save( filename, format.toUpperCase() );
}

void clearScreen()
{
    buffer.fill( colorGroup().base() );
    repaint( false );
}

protected void mousePressEvent( QMouseEvent e )
{
    mousePressed = true;
    polyline.setPoint(0, e.pos());
    polyline.setPoint(1, e.pos());
    polyline.setPoint(2, e.pos());
}

protected void mouseReleaseEvent( QMouseEvent e  )
{
    mousePressed = false;
}

protected void mouseMoveEvent( QMouseEvent e )
{
    if ( mousePressed ) {
	QPainter painter = new QPainter();
	painter.begin( buffer );
	painter.setPen( pen );
	polyline.setPoint(2, polyline.at(1));
	polyline.setPoint(1, polyline.at(0));
	polyline.setPoint(0, e.pos());
	painter.drawPolyline( polyline );
	painter.end();

	QRect r = polyline.boundingRect();
	r = r.normalize();
	r.setLeft( r.left() - penWidth() );
	r.setTop( r.top() - penWidth() );
	r.setRight( r.right() + penWidth() );
	r.setBottom( r.bottom() + penWidth() );

	bitBlt( this, r.x(), r.y(), buffer, r.x(), r.y(), r.width(), r.height() );
    }
}

protected void resizeEvent( QResizeEvent e )
{
    super.resizeEvent( e );

    int w = width() > buffer.width() ?
	    width() : buffer.width();
    int h = height() > buffer.height() ?
	    height() : buffer.height();

    QPixmap tmp = new QPixmap( buffer );
    buffer.resize( w, h );
    buffer.fill( colorGroup().base() );
    bitBlt( buffer, 0, 0, tmp, 0, 0, tmp.width(), tmp.height() );
}

protected void paintEvent( QPaintEvent e )
{
    super.paintEvent( e );
    ArrayList rects = e.region().rects();
    for ( int i = 0; i < rects.size(); i++ ) {
	QRect r = (QRect) rects.get(i);
	bitBlt( this, r.x(), r.y(), buffer, r.x(), r.y(), r.width(), r.height() );
    }
}

}

//------------------------------------------------------

Scribble( )
{
	this(null, null);
}

Scribble( QWidget parent, String name )
{
    super( parent, name );
    canvas = new Canvas( this );
    setCentralWidget( canvas );

    QToolBar tools = new QToolBar( this );

    bSave = new QToolButton( new QIconSet(), "Save", "Save as PNG image", this, SLOT(" slotSave()"), tools );
    bSave.setText( "Save as..." );

    tools.addSeparator();

    bPColor = new QToolButton( new QIconSet(), "Choose Pen Color", "Choose Pen Color", this, SLOT(" slotColor()"), tools );
    bPColor.setText( "Choose Pen Color..." );

    tools.addSeparator();

    bPWidth = new QSpinBox( 1, 20, 1, tools );
    QToolTip.add( bPWidth, "Choose Pen Width" );
    connect( bPWidth, SIGNAL(" valueChanged( int )"), this, SLOT(" slotWidth( int )") );
    bPWidth.setValue( 3 );

    tools.addSeparator();

    bClear = new QToolButton( new QIconSet(), "Clear Screen", "Clear Screen", this, SLOT(" slotClear()"), tools );
    bClear.setText( "Clear Screen" );
}

void slotSave()
{
    QPopupMenu menu = new QPopupMenu( null );
    HashMap formats = new HashMap();

    for ( int i = 0; i < QImageIO.outputFormats().size(); i++ ) {
	String str = (String) QImageIO.outputFormats().get( i );
	formats.put( new Integer(menu.insertItem( str + "..." )),  str );
    }

    menu.setMouseTracking( true );
    int id = menu.exec( bSave.mapToGlobal( new QPoint( 0, bSave.height() + 1 ) ) );

    if ( id != -1 ) {
	String format = (String) formats.get( new Integer(id) );

	String filename = QFileDialog.getSaveFileName( "", "*." + format.toLowerCase(), this );
	if ( !filename.equals("") )
	    canvas.save( filename, format );
    }

}

void slotColor()
{
    QColor c = QColorDialog.getColor( canvas.penColor(), this );
    if ( c.isValid() )
	canvas.setPenColor( c );
}

void slotWidth( int w )
{
    canvas.setPenWidth( w );
}

void slotClear()
{
    canvas.clearScreen();
}
}
