/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/

#include <qobject.h>

class Slot: public QObject
{
    Q_OBJECT
public:
    Slot();
    ~Slot();
    static Slot *new_IntSlot(qt_intCallback);
    static Slot *new_VoidSlot(qt_voidCallback);
    static Slot *new_FloatSlot(qt_floatCallback);
    static Slot *new_QRectSlot(qt_QRectCallback);
    static Slot *new_QSizeSlot(qt_QSizeCallback);
    static Slot *new_QStringSlot(qt_QStringCallback);
    static Slot *new_UserDataSlot(qt_UserDataCallback, void * userData);

       
public slots:
    void intSlot(int i);
    void voidSlot();
    void floatSlot(float f);
    void QRectSlot(QRect f);
    void QSizeSlot(QSize f);
    void QStringSlot(const QString &s);
    void UserDataSlot();
    void UserDataSlot(int);
    void UserDataSlot(void *);
private:
    union
    {
        qt_intCallback intf;
        qt_voidCallback voidf;
        qt_floatCallback floatf;
        qt_QRectCallback qrectf;
        qt_QSizeCallback qsizef;
	qt_QStringCallback qss;
        qt_UserDataCallback userdataf;
    };
    void * userData;
};

class Signal: public QObject
{
    Q_OBJECT
public:
    Signal();
    ~Signal();
    void emitInt(int);
    void emitVoid();
    void emitFloat(float);
    void emitPointer(void *);
signals:
    void intSignal(int);
    void voidSignal();
    void floatSignal(float);
    void pointerSignal(void *);
};




