/***************************************************************************
                            KStandardDirs.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTANDARDDIRS_H
#define KSTANDARDDIRS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 This is one of the most central classes in kdelibs as
 it provides a basic service: It knows where the files
 reside on the user's hard disk. And it's meant to be the
 only one that knows -- to make the real location as
 transparent as possible to both the user and the applications.

 To this end it insulates the application from all information
 and applications always refer to a file with a resource type
 (e.g. icon) and a filename (e.g. khexdit.xpm). In an ideal world
 the application would make no assumption where this file is and
 leave it up to @ref -[KStandardDirs findResource]("apps", "Home.desktop")
 to apply this knowledge to return /opt/kde/share/applnk/Home.desktop
 or locate("data", "kgame/background.jpg") to return
 /opt/kde/share/apps/kgame/background.jpg

 The main idea behind KStandardDirs is that there are several
 toplevel prefixes below which the files lie. One of these prefixes is
 the one where the user installed kdelibs, one is where the
 application was installed, and one is $HOME/.kde, but there
 may be even more. Under these prefixes there are several well
 defined suffixes where specific resource types are to be found.
 For example, for the resource type "html" the suffixes could be
 share/doc/HTML and share/doc/kde/HTML.
 So the search algorithm basicly appends to each prefix each registered
 suffix and tries to locate the file there.
 To make the thing even more complex, it's also possible to register
 absolute paths that KStandardDirs looks up after not finding anything
 in the former steps. They can be useful if the user wants to provide
 specific directories that aren't in his $HOME/.kde directory for,
 for example, icons.

 A type that is added by the class @ref KApplication if you use it, is
 appdata. This one makes the use of the type data a bit easier as it
 appends the name of the application.
 So while you had to @ref locate("data", "appname/filename") so you can
 also write @ref locate("appdata", "filename") if your KApplication instance
 is called "appname". Please note though that you cannot use the "appdata"
 type if you intend to use it in an applet for Kicker because 'appname' would
 be "Kicker" instead of the applet's name. Therefore, for applets, you've got
 to work around this by using @ref locate("data", "appletname/filename").

 @author Stephan Kulow <coolo@kde.org> and Sirtaj Singh Kang <taj@kde.org>

 @version $Id: KStandardDirs.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short Site-independent access to standard KDE directories.

*/
@class KConfig; 

@interface  KStandardDirs : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 KStandardDirs constructor. It just initializes the caches.

*/
- init;

/** 
 KStandardDirs destructor.
	 
*/
- (void) dealloc;

/** 
 Adds another search dir to front of the @p fsstnd list.

*/
- addPrefix: (NSString *)dir;

/** 
 Adds suffixes for types.

 You may add as many as you need, but it is advised that there
 is exactly one to make writing definite.
 All basic types (@ref kde_default) are added by @ref -addKDEDefaults,
 but for those you can add more relative paths as well.

 The later a suffix is added, the higher its priority. Note, that the
 suffix should end with / but doesn't have to start with one (as prefixes
 should end with one). So adding a suffix for app_pics would look
 like -[KGlobal dirs]->addResourceType("app_pics", "share/app/pics");

*/
- (BOOL) addResourceType: (NSString *)type relativename: (NSString *)relativename;

/** 
 Adds absolute path at the end of the search path for
 particular types (for example in case of icons where
 the user specifies extra paths).

 You shouldn't need this
 function in 99% of all cases besides adding user-given
 paths.

	 
*/
- (BOOL) addResourceDir: (NSString *)type absdir: (NSString *)absdir;

/** 
 Tries to find a resource in the following order:

 The filename should be a filename relative to the base dir
 for resources. So is a way to get the path to libkdecore.la
 to findResource("lib", "libkdecore.la"). KStandardDirs will
 then look into the subdir lib of all elements of all prefixes
 ($KDEDIRS) for a file libkdecore.la and return the path to
 the first one it finds (e.g. /opt/kde/lib/libkdecore.la)

*/
- (NSString *) findResource: (NSString *)type filename: (NSString *)filename;

/** 
 Returns a number that identifies this version of the resource.
 When a change is made to the resource this number will change.

*/
- (unsigned int) calcResourceHash: (NSString *)type filename: (NSString *)filename deep: (BOOL)deep;

/** 
 Tries to find all directories whose names consist of the
 specified type and a relative path. So would
 findDirs("apps", "Settings") return

 Note that it appends / to the end of the directories,
 so you can use this right away as directory names.

*/
- (NSArray *) findDirs: (NSString *)type reldir: (NSString *)reldir;

/** 
 Tries to find the directory the file is in.
 It works the same as @ref -findResource, but it doesn't
 return the filename but the name of the directory.

 This way the application can access a couple of files
 that have been installed into the same directory without
 having to look for each file.

 findResourceDir("lib", "libkdecore.la") would return the
 path of the subdir libkdecore.la is found first in
 (e.g. /opt/kde/lib/)

*/
- (NSString *) findResourceDir: (NSString *)type filename: (NSString *)filename;

/** 
 Tries to find all resources with the specified type.

 The function will look into all specified directories
 and return all filenames in these directories.

*/
- (NSArray *) findAllResources: (NSString *)type filter: (NSString *)filter recursive: (BOOL)recursive uniq: (BOOL)uniq;

/** 
 Tries to find all resources with the specified type.

 The function will look into all specified directories
 and return all filenames (full and relative paths) in
 these directories.

*/
- (NSArray *) findAllResources: (NSString *)type filter: (NSString *)filter recursive: (BOOL)recursive uniq: (BOOL)uniq relPaths: (NSArray *)relPaths;

/** 
 This function adds the defaults that are used by the current
 KDE version.

 It's a series of @ref -addResourceTypes
 and @ref -addPrefix calls.
 You normally wouldn't call this function because it's called
 for you from @ref KGlobal.
	 
*/
- addKDEDefaults;

/** 
 Reads customized entries out of the given config object and add
 them via @ref -addResourceDirs.

*/
- (BOOL) addCustomized: (KConfig*)config;

/** 
 This function is used internally by almost all other function as
 it serves and fills the directories cache.

*/
- (NSArray *) resourceDirs: (NSString *)type;

/** 
 This function will return a list of all the types that KStandardDirs
 supports.

*/
- (NSArray *) allTypes;

/** 
 Finds a location to save files into for the given type
 in the user's home directory.

*/
- (NSString *) saveLocation: (NSString *)type suffix: (NSString *)suffix create: (BOOL)create;

/** 
 Converts an absolute path to a path relative to a certain
 resource.

 If "abs = locate(resource, rel)"
 then "rel = relativeLocation(resource, abs)" and vice versa.

*/
- (NSString *) relativeLocation: (NSString *)type absPath: (NSString *)absPath;

/** 

	 
*/
- (NSString *) kfsstnd_prefixes;

/** 

 Don't use this function if you can use locateLocal
	 
*/
- (NSString *) localkdedir;

/** 
 Finds the executable in the system path.

 A valid executable must
 be a file and have its executable bit set.

*/
+ (NSString *) findExe: (NSString *)appname pathstr: (NSString *)pathstr ignoreExecBit: (BOOL)ignoreExecBit;

/** 
 Finds all occurences of an executable in the system path.

*/
+ (int) findAllExe: (NSArray *)list appname: (NSString *)appname pathstr: (NSString *)pathstr ignoreExecBit: (BOOL)ignoreExecBit;
+ (int) findAllExe: (NSArray *)list appname: (NSString *)appname ;

/** 
 Recursively creates still-missing directories in the given path.

 The resulting permissions will depend on the current umask setting.
 permission = mode & ~umask.

*/
+ (BOOL) makeDir: (NSString *)dir mode: (int)mode;
+ (BOOL) makeDir: (NSString *)dir ;

/** 
 This returns a default relative path for the standard KDE
 resource types. Below is a list of them so you get an idea
 of what this is all about.

*/
+ (NSString *) kde_default: (NSString *)type;

/** 
 checks for existence and accessability
 faster than creating a QFileInfo first
	 
*/
+ (BOOL) exists: (NSString *)fullPath;
@end

#endif
