/***************************************************************************
                            KIntNumInput.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KINTNUMINPUT_H
#define KINTNUMINPUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KNumInput.h>

/**

 KIntNumInput combines a @ref QSpinBox and optionally a @ref QSlider
 with a label to make an easy to use control for setting some integer
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KIntNumInput, designed specifically for
 the situation when there are several KIntNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses @ref KIntValidator validator class. KIntNumInput enforces the
 value to be in the given range, and can display it in any base
 between 2 and 36.

 @version $Id: KIntNumInput.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short An input widget for integer numbers, consisting of a spinbox and a slider.

*/
@interface KIntNumInput : KNumInput 

/** 
 Constructs an input control for integer values
 with base 10 and initial value 0.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructor
 It constructs a QSpinBox that allows the input of integer numbers
 in the range of -INT_MAX to +INT_MAX. To set a descriptive label,
 use -setLabel. To enforce the value being in a range and optionally to
 attach a slider to it, use -setRange.

*/
- initWithInt: (int)value parent: (QWidget *)parent base: (int)base name: (NSString *)name;
- initWithInt: (int)value ;

/** 
 Constructor

 the difference to the one above is the "below" parameter. It tells
 this instance that it is visually put below some other KNumInput widget.
 Note that these two KNumInput's need not to have the same parent widget
 or be in the same layout group.
 The effect is that it'll adjust it's layout in correspondence
 with the layout of the other KNumInput's (you can build an arbitary long
 chain).

*/
- initWithNumInput: (KNumInput*)below value: (int)value parent: (QWidget *)parent base: (int)base name: (NSString *)name;
- initWithNumInput: (KNumInput*)below value: (int)value ;

/** 
 Destructor

     
*/
- (void) dealloc;

/** 

*/
- (int) value;

/** 

*/
- (NSString *) suffix;

/** 

*/
- (NSString *) prefix;

/** 

*/
- (NSString *) specialValueText;

/** 

*/
- setRange: (int)min max: (int)max step: (int)step slider: (BOOL)slider;
- setRange: (int)min max: (int)max ;

/** 
 Sets the minimum value.
     
*/
- setMinValue: (int)min;

/** 

*/
- (int) minValue;

/** 
 Sets the maximum value.
     
*/
- setMaxValue: (int)max;

/** 

*/
- (int) maxValue;

/** 
 Sets the special value text. If set, the SpinBox will display
 this text instead of the numeric value whenever the current
 value is equal to -minVal. Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
- setSpecialValueText: (NSString *)text;

/** 
 This method returns the minimum size necessary to display the
 control. The minimum size is enough to show all the labels
 in the current font (font change may invalidate the return value).

*/
- (QSize*) minimumSizeHint;

/** 
 Sets the value of the control.
     
*/
- setValue: (int)arg1;

/** 
 Sets the suffix to @p suffix.
 Use -[QString null]to disable this feature.
 Formatting has to be provided (e.g. a space separator between the
 prepended @p value and the suffix's text has to be provided
 as the first character in the suffix).

*/
- setSuffix: (NSString *)suffix;

/** 
 Sets the prefix to @p prefix.
 Use -[QString null]to disable this feature.
 Formatting has to be provided (see above).

*/
- setPrefix: (NSString *)prefix;

/** 
 sets focus to the edit widget and marks all text in if mark == true

     
*/
- setEditFocus: (BOOL)mark;
- setEditFocus;
@end

/** Override these methods in subclasses of KIntNumInput to customise event handling behaviour */
@protocol KIntNumInputEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 

     
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
