/***************************************************************************
                            HTMLCollection.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLCOLLECTION_H
#define HTMLCOLLECTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 An <code> HTMLCollection </code> is a list of nodes. An individual
 node may be accessed by either ordinal index or the node's <code>
 name </code> or <code> id </code> attributes. Note: Collections in
 the HTML DOM are assumed to be live meaning that they are
 automatically updated when the underlying document is changed.

 
 @short 
 An <code> HTMLCollection </code> is a list of nodes.
*/
@class DOMNode; 



@interface  HTMLCollection : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 This attribute specifies the length or size of the list.

     
*/
- (unsigned long) length;

/** 
 This method retrieves a node specified by ordinal index. Nodes
 are numbered in tree order (depth-first traversal order).

     
*/
- (DOMNode*) item: (unsigned long)index;

/** 
 This method retrieves a <code> Node </code> using a name. It
 first searches for a <code> Node </code> with a matching <code>
 id </code> attribute. If it doesn't find one, it then searches
 for a <code> Node </code> with a matching <code> name </code>
 attribute, but only on those elements that are allowed a name
 attribute.

     
*/
- (DOMNode*) namedItem: (NSString *)name;

/** 

 not part of the DOM
     
*/
- (DOMNode*) base;
- (BOOL) isNull;
- (DOMNode*) firstItem;
- (DOMNode*) nextItem;
- (DOMNode*) nextNamedItem: (NSString *)name;
@end

#endif
