//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QCustomEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 Class for manipulating the application startup notification.
 This class can be used to send information about started application,
 change the information and receive this information. For detailed
 description, see kdelibs/kdecore/README.kstartupinfo.
 You usually don't need to use this class for sending the notification
 information, as KDE libraries should do this when an application is
 started (e.g. KRun class).
 For receiving the startup notification info, create an instance and connect
 to its slots. It will automatically detect started applications and when
 they are ready.
 See {@link KStartupInfoSignals} for signals emitted by KStartupInfo
		@author Lubos Lunak <l.lunak@kde.org>

		@version  kstartupinfo.h,v 1.28 2003/10/23 17:40:25 lunakl
 
		@short    Class for manipulating the application startup notification.
		@see KStartupInfoId
		@see KStartupInfoData

*/
public class KStartupInfo extends QObject  {
	protected KStartupInfo(Class dummy){super((Class) null);}
	public static final int CleanOnCantDetect = 1<<0;
	public static final int DisableKWinModule = 1<<1;
	public static final int AnnounceSilenceChanges = 1<<2;

	/**	
		
			<li>
			NoMatch    - the window doesn't match any existing startup notification
			</li>
			
			<li>
			Match      - the window matches an existing startup notification
			</li>
			
			<li>
			CantDetect - unable to detect if the window matches any existing
						startup notification
				 
			</li>		@short
	*/
	public static final int NoMatch = 0;
	public static final int Match = 1;
	public static final int CantDetect = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Creates an instance that will receive the startup notifications.
		 The various flags passed may be
		
			<li>
			CleanOnCantDetect - when a new unknown window appears, all startup
			     notifications for applications that are not compliant with
			     the startup protocol are removed
			</li>
			
			<li>
			DisableKWinModule - KWinModule, which is normally used to detect
			     new windows, is disabled. With this flag, checkStartup() must be
			     called in order to check newly mapped windows.
			</li>
			
			<li>
			AnnounceSilenceChanges - normally, startup notifications are
			     "removed" when they're silenced, and "recreated" when they're resumed.
			     With this flag, the change is normally announced with gotStartupChange().
			</li>
				@param flags OR-ed combination of flags
			@param parent the parent of this QObject (can be 0 for no parent)
			@param name the name of the QObject (can be 0 for no name)
				 		@short    Creates an instance that will receive the startup notifications.
	*/
	public KStartupInfo(int flags, QObject parent, String name) {
		super((Class) null);
		newKStartupInfo(flags,parent,name);
	}
	private native void newKStartupInfo(int flags, QObject parent, String name);
	public KStartupInfo(int flags, QObject parent) {
		super((Class) null);
		newKStartupInfo(flags,parent);
	}
	private native void newKStartupInfo(int flags, QObject parent);
	public KStartupInfo(int flags) {
		super((Class) null);
		newKStartupInfo(flags);
	}
	private native void newKStartupInfo(int flags);
	/**	
		 Checks if the given windows matches any existing startup notification.
			@param w the window id to check
				@return the result of the operation
	 
		@short    Checks if the given windows matches any existing startup notification.
	*/
	public native int checkStartup(long w);
	/**	
		 Checks if the given windows matches any existing startup notification, and
		 if yes, returns the identification in id.
			@param w the window id to check
			@param id if found, the id of the startup notification will be written here
				@return the result of the operation
	 
		@short    Checks if the given windows matches any existing startup notification, and  if yes, returns the identification in id.
	*/
	public native int checkStartup(long w, KStartupInfoId id);
	/**	
		 Checks if the given windows matches any existing startup notification, and
		 if yes, returns the notification data in data.
			@param w the window id to check
			@param data if found, the data of the startup notification will be written here
				@return the result of the operation
	 
		@short    Checks if the given windows matches any existing startup notification, and  if yes, returns the notification data in data.
	*/
	public native int checkStartup(long w, KStartupInfoData data);
	/**	
		 Checks if the given windows matches any existing startup notification, and
		 if yes, returns the identification in id and notification data in data.
			@param w the window id to check
			@param id if found, the id of the startup notification will be written here
			@param data if found, the data of the startup notification will be written here
				@return the result of the operation
	 
		@short    Checks if the given windows matches any existing startup notification, and  if yes, returns the identification in id and notification data in data.
	*/
	public native int checkStartup(long w, KStartupInfoId id, KStartupInfoData data);
	/**	
		 Sets the timeout for notifications, after this timeout a notification is removed.
			@param secs the new timeout in seconds
			 		@short    Sets the timeout for notifications, after this timeout a notification is removed.
	*/
	public native void setTimeout(int secs);
	/**	
		 By default, the startup notification is ended for the application
		 after it shows its first toplevel window. If you app e.g. has
		 several toplevel windows after its startup, you can disable
		 the automatic handling, and call appStarted() manually after
		 all toplevel windows have been shown.
				@short    By default, the startup notification is ended for the application  after it shows its first toplevel window.
	*/
	public static native void disableAutoAppStartedSending(boolean disable);
	public static native void disableAutoAppStartedSending();
	/**	
		 Manual notification that the application has started.
		 If you do not map a (toplevel) window, then startup
		 notification will not disappear for the application
		 until a timeout. You can use this as an alternative
		 method in this case.
		         		@short    Manual notification that the application has started.
	*/
	public static native void appStarted();
	/**	
		 Sends explicit notification that the startup notification
		 with id startup_id should end.
				@short    Sends explicit notification that the startup notification  with id startup_id should end.
	*/
	public static native void appStarted(String startup_id);
	/**	
		 Use this function if the application got a request with startup
		 notification from outside (for example, when KUniqueApplication.newInstance()
		 is called, or e.g. when khelpcenter opens new URL in its window).
		 The window can be either an already existing and visible window,
		 or a new one, before being shown. Note that this function is usually
		 needed only when a window is reused.
				@short    Use this function if the application got a request with startup  notification from outside (for example, when KUniqueApplication.newInstance()  is called, or e.
	*/
	public static native void setNewStartupId(QWidget window, String startup_id);
	/**	
		 If your application shows temporarily some window during its startup,
		 for example a dialog, and only after closing it shows the main window,
		 startup notification would normally be shown while the dialog is visible.
		 To temporarily suspend and resume the notification, use this function.
		 Note that this is cumulative, i.e. after suspending twice, you have to
		 resume twice.
				@short    If your application shows temporarily some window during its startup,  for example a dialog, and only after closing it shows the main window,  startup notification would normally be shown while the dialog is visible.
	*/
	public static native void silenceStartup(boolean silence);
	/**	
		 Sends given notification data about started application
		 with the given startup identification. If no notification for this identification
		 exists yet, it is created, otherwise it's updated. Note that the name field
		 in data is required.
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise

		@short    Sends given notification data about started application  with the given startup identification.
		@see KStartupInfoId
		@see KStartupInfoData
	*/
	public static native boolean sendStartup(KStartupInfoId id, KStartupInfoData data);
	/**	
		 Like sendStartup , uses dpy instead of qt_x11display() for sending the info.
			@param dpy the display of the application. Note that the name field
		 in data is required.
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise
	 
		@short    Like sendStartup , uses dpy instead of qt_x11display() for sending the info.
	*/
	// bool sendStartupX(Display* arg1,const KStartupInfoId& arg2,const KStartupInfoData& arg3); >>>> NOT CONVERTED
	/**	
		 Sends given notification data about started application
		 with the given startup identification. This is used for updating the notification
		 info, if no notification for this identification exists, it's ignored.
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise

		@short    Sends given notification data about started application  with the given startup identification.
		@see KStartupInfoId
		@see KStartupInfoData
	*/
	public static native boolean sendChange(KStartupInfoId id, KStartupInfoData data);
	/**	
		 Like sendChange , uses dpy instead of qt_x11display() for sending the info.
			@param dpy the display of the application.
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise
	 
		@short    Like sendChange , uses dpy instead of qt_x11display() for sending the info.
	*/
	// bool sendChangeX(Display* arg1,const KStartupInfoId& arg2,const KStartupInfoData& arg3); >>>> NOT CONVERTED
	/**	
		 Ends startup notification with the given identification.
			@param id the id of the application
				@return true if successful, false otherwise
	 
		@short    Ends startup notification with the given identification.
	*/
	public static native boolean sendFinish(KStartupInfoId id);
	/**	
		 Like sendFinish , uses dpy instead of qt_x11display() for sending the info.
			@param dpy the display of the application.
			@param id the id of the application
				@return true if successful, false otherwise
	 
		@short    Like sendFinish , uses dpy instead of qt_x11display() for sending the info.
	*/
	// bool sendFinishX(Display* arg1,const KStartupInfoId& arg2); >>>> NOT CONVERTED
	/**	
		 Ends startup notification with the given identification and the given data ( e.g.
		 PIDs of processes for this startup notification that exited ).
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise
	 
		@short    Ends startup notification with the given identification and the given data ( e.
	*/
	public static native boolean sendFinish(KStartupInfoId id, KStartupInfoData data);
	/**	
		 Like sendFinish , uses dpy instead of qt_x11display() for sending the info.
			@param dpy the display of the application.
			@param id the id of the application
			@param data the application's data
				@return true if successful, false otherwise
	 
		@short    Like sendFinish , uses dpy instead of qt_x11display() for sending the info.
	*/
	// bool sendFinishX(Display* arg1,const KStartupInfoId& arg2,const KStartupInfoData& arg3); >>>> NOT CONVERTED
	/**	
		 Returns the current startup notification identification for the current
		 startup notification environment variable. Note that KApplication constructor
		 unsets the variable and you have to use KApplication.startupId .
				@return the current startup notification identification
	 
		@short    Returns the current startup notification identification for the current  startup notification environment variable.
	*/
	public static native KStartupInfoId currentStartupIdEnv();
	/**	
		 Unsets the startup notification environment variable.
			 		@short    Unsets the startup notification environment variable.
	*/
	public static native void resetStartupEnv();
	/**	
		 Sets the startup notification window property on the given window.
			@param window the id of the window
			@param id the startup notification id
			 		@short    Sets the startup notification window property on the given window.
	*/
	public static native void setWindowStartupId(long window, String id);
	/**	
		 Returns startup notification identification of the given window.
			@param w the id of the window
				@return the startup notification id. Can be null if not found.
	 
		@short    Returns startup notification identification of the given window.
	*/
	public static native String windowStartupId(long w);
	/**	
			         		@short
	*/
	public static native void handleAutoAppStartedSending();
	protected native void customEvent(QCustomEvent e_P);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
