/***************************************************************************
                            kde_KWin.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KWIN
#define KDE_KWIN

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Convenience access to certain properties and features of the
 window manager.

 This class is not supposed to be instantiated.  It exists mostly as
 a namespace for the static member functions.

 In KDE 2 and KDE 3, communication with the windowmanager is done with the
 NET-protocol, a common window manager specification designed by
 various authors of X11 window managers (including those of the KDE
 project).  The full specification can be found in
 kdebase/kwin/wm-spec/

 To access features of the NET-protocol, use the classes @ref NETRootInfo
 and @ref NETWinInfo.

 The purpose of this class is to to provide easy access to the
 most-commonly used NET-features with a simpler, KDEish interface.

 In addition, it encapsulates KDE functionality not yet provided by
 the NET hints.  Currently that is invokeContextHelp() and
 setSystemTrayWindowFor() only.

 @author Matthias Ettrich (ettrich@kde.org)

 @short Class for interaction with the window manager.

*/

/** *
 Sets window @p win to be the active window.

 This is a request to the window manager. It may or may not be
 obeyed.

*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_KWin_setActiveWindow( unsigned int win);

/** *
 Invokes interactive context help.
     
*/
void kde_KWin_invokeContextHelp( );

/** *
 Makes @p trayWin a system tray window for @p forWin.

 A system tray window serves as an icon replacement. It's
 displayed inside the panel's system tray.

*/
void kde_KWin_setSystemTrayWindowFor( unsigned int trayWin, unsigned int forWin);

/** *
 Returns information about window @p win.

*/

/** *
 Returns an icon for window @p win.

 If  @p width and @p height are specified, the best icon for the requested
 size is returned.

 If @p scale is true, the icon is smooth-scaled to have exactly
 the requested size.

*/
qt_QPixmap * kde_KWin_icon( unsigned int win, int width, int height, int scale);

/** *
 Sets an @p icon and a  @p miniIcon on window @p win

*/
void kde_KWin_setIcons( unsigned int win, qt_QPixmap * icon, qt_QPixmap * miniIcon);

/** *
 Sets the type of window @p win to @p windowType.

 Possible values are NET::Normal, NET::Desktop, NET::Dock,
 NET::Tool, NET::Menu, NET::Dialog, NET::Override (== no
 decoration frame) or NET::TopMenu

*/
void kde_KWin_setType( unsigned int win, int windowType);

/** *
 Sets the state of window @p win to @p state.

 Possible values are or'ed combinations of NET::Modal,
 NET::Sticky, NET::MaxVert, NET::MaxHoriz, NET::Shaded,
 NET::SkipTaskbar, NET::StaysOnTop, NET::SkipPager

*/
void kde_KWin_setState( unsigned int win, unsigned long state);

/** *
 Clears the state of window @p win from @p state.

 Possible values are or'ed combinations of NET::Modal,
 NET::Sticky, NET::MaxVert, NET::MaxHoriz, NET::Shaded,
 NET::SkipTaskbar, NET::StaysOnTop, NET::SkipPager

*/
void kde_KWin_clearState( unsigned int win, unsigned long state);

/** *
 Sets window @p win to be present on all virtual desktops if @p
 is true. Otherwise the window lives only on one single desktop.

*/
void kde_KWin_setOnAllDesktops( unsigned int win, int b);

/** *
 Moves window @p win to desktop @p desktop.

*/
void kde_KWin_setOnDesktop( unsigned int win, int desktop);

/** *
 Sets the strut of window @p win to @p left, @p right, @p top, @p bottom.

*/
void kde_KWin_setStrut( unsigned int win, int left, int right, int top, int bottom);

/** *
 Convenience function to access the current desktop.  See @ref NETRootInfo.

*/
int kde_KWin_currentDesktop( );

/** *
 Convenience function to access the number of desktops. See @ref
 NETRootInfo.

*/
int kde_KWin_numberOfDesktops( );

/** *
 Convenience function to set the current desktop to @p desktop.
 See @ref NETRootInfo.

*/
void kde_KWin_setCurrentDesktop( int desktop);

/** *
 Iconifies a window. Compatible to XIconifyWindow but has an
 additional parameter @p animation.

*/
void kde_KWin_iconifyWindow( unsigned int win, int animation);

/** *
 DeIconifies a window. Compatible to XMapWindow but has an
 additional parameter @p animation.

*/
void kde_KWin_deIconifyWindow( unsigned int win, int animation);

/** *

 Use @ref KStartupInfo::appStarted
     
*/
void kde_KWin_appStarted( );

#ifdef __cplusplus
}
#endif
#endif
