/***************************************************************************
                            kde_KImageIO.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KIMAGEIO
#define KDE_KIMAGEIO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Interface to the KDE Image IO plugin architecture.

 This library allows KDE applications to read and write images in a
 variety of formats, transparently via the @ref QImage and @ref QPixmap load
 and save methods.

 The image processing backends are written as image handlers compatible
 with the @ref QImageIO handler format. The backends are loaded on demand
 when a particular format is requested. Each format can be identified
 by a unique type id string.

 Currently supported formats include:

 Simply call the @ref KImageIO::registerFormats() static method declared
 in kimgageio.h.

 <pre>
	#include<qpixmap.h>
 	#include<kimgio.h>

	int main( int argc, char **argv )
	{
		....
		KImageIO::registerFormats();

		...	// start main program
	}
 </pre>

 @author Sirtaj Singh Kang

 @version $Id: kde_KImageIO.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $
 
 @short *
 Interface to the KDE Image IO plugin architecture.
*/
#define KIMAGEIO_Reading	0
#define KIMAGEIO_Writing	1

/** *
  Registers all KImageIO supported formats.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_KImageIO_registerFormats( );

/** *
 Checks if a special type is supported for writing.

*/
int kde_KImageIO_canWrite( qt_QString * type);

/** *
 Checks if a special type is supported for reading.

*/
int kde_KImageIO_canRead( qt_QString * type);

/** *
 Returns a list of all KImageIO supported formats. 

*/
qt_QStringList* kde_KImageIO_types( int mode);

/** *
 Returns a list of patterns of all KImageIO supported formats. 

 These patterns can be passed to @ref KFileDialog::getOpenFileName()
 or @ref KFileDialog::getSaveFileName(), for example.

*/
qt_QString * kde_KImageIO_pattern( int mode);

/** *
 Returns the suffix of an image type.

*/
qt_QString * kde_KImageIO_suffix( qt_QString * type);

/** *
 Returns the type of a MIME type.

*/
qt_QString * kde_KImageIO_typeForMime( qt_QString * mimeType);

/** *
 Returns the type of given filename.

*/
qt_QString * kde_KImageIO_type( qt_QString * filename);

/** *
  Returns a list of MIME types for all KImageIO supported formats. 

*/
qt_QStringList* kde_KImageIO_mimeTypes( int _mode);

/** *
 Test to see whether a MIME type is supported to reading/writing.

*/
int kde_KImageIO_isSupported( qt_QString * _mimeType, int _mode);

/** *
 Returns the MIME type of @p _filename.

*/
qt_QString * kde_KImageIO_mimeType( qt_QString * _filename);

#ifdef __cplusplus
}
#endif
#endif
