/***************************************************************************
                            kde_FMOut.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_FMOUT
#define KDE_FMOUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 FM device output class . FMOut is used to send MIDI events to 
 FM devices, such as AdLib cards, or OPL3 synthesizers.

 FMOut inherits @ref MidiOut and supports the same simple API.

 The preferred way to use this class is by selecting a FM device
 on the @ref MidiManager and using a @ref MidiManager object directly

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to FM devices.
*/

/** *
 Constructor. See @ref MidiOut::MidiOut() for more information.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_FMOut * kde_new_FMOut(int d, int total);

/** *
 Destructor. 
     
*/
void kde_del_FMOut( kde_FMOut* p );

/** *
 See @ref MidiOut::openDev()
     
*/
void kde_FMOut_openDev(kde_FMOut* instPointer,int sqfd);

/** *
 See @ref MidiOut::closeDev()
     
*/
void kde_FMOut_closeDev(kde_FMOut* instPointer);

/** *
 See @ref MidiOut::initDev()
     
*/
void kde_FMOut_initDev(kde_FMOut* instPointer);

/** *
 See @ref MidiOut::noteOn()
     
*/
void kde_FMOut_noteOn(kde_FMOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::noteOff()
     
*/
void kde_FMOut_noteOff(kde_FMOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::keyPressure()
     
*/
void kde_FMOut_keyPressure(kde_FMOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::chnPatchChange()
     
*/
void kde_FMOut_chnPatchChange(kde_FMOut* instPointer,unsigned char chn, unsigned char patch);

/** *
 See @ref MidiOut::chnPressure()
     
*/
void kde_FMOut_chnPressure(kde_FMOut* instPointer,unsigned char chn, unsigned char vel);

/** *
 See @ref MidiOut::chnPitchBender()
     
*/
void kde_FMOut_chnPitchBender(kde_FMOut* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** *
 See @ref MidiOut::chnController()
     
*/
void kde_FMOut_chnController(kde_FMOut* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** *
 It's an empty function, as FM devices don't support System Exclusive
 messages
     
*/
void kde_FMOut_sysex(kde_FMOut* instPointer,unsigned char* data, unsigned long size);

/** *
 See @ref MidiOut::setVolumePercentage()
     
*/
void kde_FMOut_setVolumePercentage(kde_FMOut* instPointer,int i);

/** *
 Returns @p p if the patch p has been loaded, or another patch (already loaded)
 if @p p hasn't been loaded. 
     
*/
int kde_FMOut_patch(kde_FMOut* instPointer,int p);

/** *
 Sets the directory where the FM patches are stored, that is, where the
 std.o3, std.sb, drums.o3 and drums.sb files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
void kde_FMOut_setFMPatchesDirectory( char* dir);

#ifdef __cplusplus
}
#endif
#endif
