/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kglobal.h>

#include "pluginmanager.h"
#include "pluginloader.h"
#include "containerarea.h"
#include "container_base.h"
#include "container_applet.h"

#include "panelmenuiteminfo.h"
#include "removeapplet_mnu.h"
#include "removeapplet_mnu.moc"

PanelRemoveAppletMenu::PanelRemoveAppletMenu( ContainerArea* cArea,
					      QWidget *parent, const char *name )
    : QPopupMenu( parent, name ), containerArea( cArea )
{
    connect( this, SIGNAL( activated( int ) ), SLOT( slotExec( int ) ) );
    connect( this, SIGNAL( aboutToShow() ), SLOT( slotAboutToShow() ) );

    containers.setAutoDelete( FALSE );
}

void PanelRemoveAppletMenu::slotAboutToShow()
{
    int id = 0;

    clear();
    containers = containerArea->containers( "Applet" );

    QValueList<PanelMenuItemInfo> items;

    for( QPtrListIterator<BaseContainer> it( containers ); it.current() ; ++it ) {
        const AppletInfo info = static_cast<AppletContainer*>( it.current() )->info();
        items.append(PanelMenuItemInfo(QString::null, info.name().replace( "&", "&&" ), id ));
        id++;
    }

    qHeapSort(items);
    QValueList<PanelMenuItemInfo>::iterator it = items.begin();
    for (; it != items.end(); ++it)
    {
        (*it).plug(this);
    }

    if ( containers.count() > 1 ) {
        insertSeparator();
        insertItem( i18n( "All" ), this, SLOT( slotRemoveAll() ) );
    }
}

void PanelRemoveAppletMenu::slotExec( int id )
{
    if ( containers.at( id ) )
	containerArea->removeContainer( containers.at( id ) );
}

PanelRemoveAppletMenu::~PanelRemoveAppletMenu()
{

}

void PanelRemoveAppletMenu::slotRemoveAll()
{
    for( QPtrListIterator<BaseContainer> it( containers ); it.current() ; ++it )
	containerArea->removeContainer( it.current() );
}
