/***************************************************************************
                          devicebutton.cpp  -  description
                             -------------------
    begin                : jeu jui 24 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "devicebutton.h"
#include "devicepopupmenu.h"

#include <qpainter.h>
#include <qdrawutil.h>
#include <qpopupmenu.h>
#include <qtooltip.h>

#include <kmessagebox.h>
#include <kmimetype.h>
#include <klocale.h>
#include <kdesktopfile.h>
#include <krun.h>
#include <kglobalsettings.h>
#include <kcursor.h>
#include <kapplication.h>
#include <kipc.h>
#include <kiconloader.h>
#include <kurldrag.h>

DeviceButton::DeviceButton(QWidget *parent, const KFileItem &fileItem)
	: QButton(parent), mFileItem(fileItem)
{
	if (parent && !parent->parent())
		setBackgroundMode(X11ParentRelative);
	setBackgroundOrigin(AncestorOrigin);
	setMouseTracking(true);
	
	mHighlight = false;

	QToolTip::add(this, mFileItem.name());

	mChangeCursorOverItem = KGlobalSettings::changeCursorOverIcon();

        if(mChangeCursorOverItem)
        {
		setCursor(KCursor().handCursor());
        }
        else
        {
		unsetCursor();
        }

        refreshIcon();

	resize(20, 20);

	slotSettingsChanged(KApplication::SETTINGS_MOUSE);

	connect(kapp, SIGNAL(settingsChanged(int)), SLOT(slotSettingsChanged(int)));
	connect(kapp, SIGNAL(iconChanged(int)), SLOT(slotIconChanged(int)));

	kapp->addKipcEventMask(KIPC::SettingsChanged);
	kapp->addKipcEventMask(KIPC::IconChanged);
}

DeviceButton::~DeviceButton()
{
}

const KFileItem &DeviceButton::fileItem() const
{
	return mFileItem;
}

void DeviceButton::setFileItem(const KFileItem &fileItem)
{
	mFileItem = fileItem;
	QToolTip::remove(this);
	QToolTip::add(this, mFileItem.name());
	refreshIcon();
}

      
void DeviceButton::refreshIcon()
{
	KMimeType::Ptr mime = mFileItem.determineMimeType();
	mIcon = mime->pixmap(KIcon::Panel, width()-4, KIcon::DefaultState);
	mIconHighlight = mime->pixmap(KIcon::Panel, width()-4, KIcon::ActiveState);
	repaint();
}


void DeviceButton::slotSettingsChanged(int category)
{
	if(category != KApplication::SETTINGS_MOUSE) return;

	mChangeCursorOverItem = KGlobalSettings::changeCursorOverIcon();

        if(mChangeCursorOverItem)
        {
		setCursor(KCursor().handCursor());
        }
        else
        {
		unsetCursor();
        }
}

void DeviceButton::slotIconChanged(int)
{
	refreshIcon();
}

void DeviceButton::paintEvent(QPaintEvent*)
{
	QPainter p( this );
	drawButton( &p );
}

void DeviceButton::drawButton(QPainter *p)
{
	if(isDown() || isOn())
	{
		p->fillRect(rect(), colorGroup().brush(QColorGroup::Mid));
		qDrawWinButton(p, 0, 0, width(), height(), colorGroup(), true);
	}

	drawButtonLabel(p);
}

void DeviceButton::drawButtonLabel(QPainter *p)
{
	QPixmap *pix = &mIcon;
	if(mHighlight) pix = &mIconHighlight;

	int d = 2;
	if(isDown() || isOn()) d++;

	p->drawPixmap(d, d, *pix);
}
   
void DeviceButton::enterEvent(QEvent* /*e*/)
{
	mHighlight = true;
	repaint();
}

void DeviceButton::leaveEvent(QEvent* /*e*/)
{
	mHighlight = false;
	repaint();
}

void DeviceButton::resizeEvent(QResizeEvent * /*e*/)
{
	refreshIcon();
}

void DeviceButton::mousePressEvent(QMouseEvent *e)
{
	if(e->button()==LeftButton)
	{
		DevicePopupMenu menu(mFileItem, this);

		int local_x = 0;
		int local_y = 0;

		switch(mPopupDirection)
		{
		case KPanelApplet::Up:
			local_y-= menu.sizeHint().height();
			break;
		case KPanelApplet::Down:
			local_y+= mIcon.height()+8;
			break;
		case KPanelApplet::Left:
			local_x-= menu.sizeHint().width();
			break;
		case KPanelApplet::Right:
			local_x+= mIcon.width()+8;
			break;
		}

		setDown(true);
		setOn(true);

		repaint();

		menu.exec(this->mapToGlobal(QPoint(local_x, local_y)));

		setDown(false);
		setOn(false);

		repaint();
	}
	else
	{
		QButton::mousePressEvent(e);
	}
}

void DeviceButton::setPopupDirection(KPanelApplet::Direction direction)
{
	mPopupDirection = direction;
}

#include "devicebutton.moc"
