# OBS! M4 processed!
changequote([, ])
[
CHAIN=growisofs dvd+rw-format dvd+rw-booktype dvd+rw-mediainfo

dvd+rw-tools:	$(CHAIN)

WARN=#-Wall	# developers are welcomed to build with `make WARN=-Wall'
]
ifelse(OS,NetBSD,[define([OS],[BSD])CXXFLAGS+=-D__unix])
ifelse(OS,OpenBSD,[define([OS],[BSD])])
ifelse(OS,FreeBSD,[define([OS],[BSD])LDLIBS=-lcam])
ifelse(OS,BSD,[
#
# OpenBSD/NetBSD/FreeBSD section
#
CC	?=gcc
CFLAGS	+=$(WARN) -O2
CXX	?=g++
CXXFLAGS+=$(WARN) -O2 -fno-exceptions

.SUFFIXES: .c .cpp .o

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
.o:	# try to please both BSD vv&vv GNU make at the same time...
	$(CXX) $(CXXFLAGS) -o $@ $> $^ $(LDFLAGS) $(LDLIBS)

# yes, default is set-root-uid, `make BIN_MODE=0755 install' to override...
BIN_MODE?=04755
install:	dvd+rw-tools
	install -o root -m $(BIN_MODE) $(CHAIN) /usr/local/bin
	install -o root -m 0644 growisofs.1 /usr/local/man/man1
])
ifelse(OS,SunOS,[
#
# Solaris section
#
.SUFFIXES: .c .cpp .o

# check for WorkShop C++
syscmd([(CC -flags) > /dev/null 2>&1])
ifelse(sysval,0,[
CC	=cc
CFLAGS	=-O -xstrconst -w
CXX	=CC
CXXFLAGS=-O -features=no%except,conststrings -w
],[
CC	=gcc
CFLAGS	=$(WARN) -O2
CXX	=g++
CXXFLAGS=$(WARN) -O2 -fno-exceptions
])

LDLIBS=-lvolmgt

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
%:	%.o
	$(CXX) $(CXXFLAGS) -o $@ $^ $(LDFLAGS) $(LDLIBS)

install:	dvd+rw-tools
	install -o root -m 04755 $(CHAIN) /usr/local/bin
	install -o root -m 0644 growisofs.1 /usr/local/man/man1
])
ifelse(OS,HP-UX,[
#
# HP-UX section
#
.SUFFIXES: .c .cpp .o

# check for HP C++
syscmd([(aCC -E /dev/null) > /dev/null 2>&1])
ifelse(sysval,0,[
# run `make TARGET_ARCH=+DD64' for 64-bit build...
# ... or should we check for `getconf KERNEL_BITS' and/or CPU_VERSION?
# syscmd([([ `getconf KERNEL_BITS` -eq 64 ]) > /dev/null 2>&1])
CC      =cc
CFLAGS  =$(TARGET_ARCH) -O
CXX     =aCC
CXXFLAGS=$(TARGET_ARCH) -O +noeh
],[
CC	=gcc
CFLAGS	=$(WARN) -O2
CXX	=g++
CXXFLAGS=$(WARN) -O2 -fno-exceptions
])

.c.o:
	$(CC) $(CFLAGS) \
		-DSCTL_MAJOR=`/usr/sbin/lsdev -h -d sctl | awk '{print$$1}'` \
		-c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
.o:	# try to please both BSD vv&vv GNU make at the same time...
	$(CXX) $(CXXFLAGS) -o $@ $> $^ $(LDFLAGS) $(LDLIBS)

install:	dvd+rw-tools
	/usr/sbin/install -o -f /usr/local/bin  $(CHAIN)
	/usr/sbin/install -o -f /usr/local/man/man1 growisofs.1
])
ifelse(OS,IRIX64,[define([OS],[IRIX])])
ifelse(OS,IRIX,[
#
# IRIX section
#
.SUFFIXES: .c .cpp .o

# check for MIPSpro compiler
syscmd([(CC -version) > /dev/null 2>&1])
ifelse(sysval,0,[
CC	=cc
CFLAGS	=$(WARN) -O -use_readonly_const
CXX	=CC
CXXFLAGS=$(WARN) -O -use_readonly_const -LANG:exceptions=OFF
],[
CC	=gcc
CFLAGS	=$(WARN) -O2
CXX	=g++
CXXFLAGS=$(WARN) -O2 -fno-exceptions
])

LDLIBS=-lmediad
LDFLAGS=-dont_warn_unused

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
.o:
	$(CXX) $(CXXFLAGS) -o $@ $> $^ $(LDFLAGS) $(LDLIBS)

BIN_MODE=04755	# set-root-uid
install:	dvd+rw-tools
	/sbin/install -o root -m $(BIN_MODE) $(CHAIN) /usr/local/bin
	/sbin/install -o root -m 0644 growisofs.1 /usr/local/man/man1
])
ifelse(OS,Linux,[
#
# Linux section
#
CC	=gcc
CFLAGS	+=$(WARN) -O2
CXX	=g++
CXXFLAGS+=$(WARN) -O2 -fno-exceptions

LINK.o=$(LINK.cc)

prefix?=/usr/local
manprefix?=$(shell case $(prefix) in (*/usr/?*) echo $(prefix)/man ;; (*) echo $(prefix)/share/man ;; esac)

bin_mode?=0755	# yes, default is *no* set-uid
minus_o:=$(shell [[ `id -u` == 0 ]] && echo "-o root")

install:	dvd+rw-tools
	[[ -d $(prefix)/bin ]] || mkdir -p $(prefix)/bin
	install $(minus_o) -m $(bin_mode) $(CHAIN) $(prefix)/bin
	[[ -d $(manprefix)/man1 ]] || mkdir -p $(manprefix)/man1
	install $(minus_o) -m 0644 growisofs.1 $(manprefix)/man1
])
# common section
[
growisofs:		growisofs_mmc.o growisofs.o
growisofs.o:		growisofs.c
growisofs_mmc.o:	growisofs_mmc.cpp transport.hxx

dvd+rw-format:		dvd+rw-format.o
dvd+rw-format.o:	dvd+rw-format.cpp transport.hxx

dvd+rw-mediainfo:	dvd+rw-mediainfo.o
dvd+rw-mediainfo.o:	dvd+rw-mediainfo.cpp transport.hxx

dvd+rw-booktype:	dvd+rw-booktype.o
dvd+rw-booktype.o:	dvd+rw-booktype.cpp transport.hxx

rpl8:			rpl8.o
rpl8.o:			rpl8.cpp transport.hxx
+rpl8:			rpl8
#so that I can invoke `make +rpl8' to build rpl8...
]
