/***************************************************************************
                          kwifimanager_configwidget2.cpp  -  description
                             -------------------
    begin                : Fre Jan 10 2003
    copyright            : (C) 2003 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <kprocio.h>
#include <qfile.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <ksimpleconfig.h>
#include "kwifimanager_configwidget2.h"
#include "kwifimanager_configwidget2.moc"
#include "configcontainer.h"

KWifimanager_ConfigWidget2::KWifimanager_ConfigWidget2 (QWidget * parent, const char *name )
    :QWidget (parent, name)
{
  QGridLayout *organizer = new QGridLayout (this);
  activate =
    new
    QCheckBox (i18n("Load preset configuration on KDE startup"),
	       this);
  activate->setChecked (Configcontainer::use_preset_config);
  config_to_activate = new QComboBox (this);
  config_to_activate->insertItem (i18n("Config 1"));
  config_to_activate->insertItem (i18n("Config 2"));
  config_to_activate->insertItem (i18n("Config 3"));
  config_to_activate->insertItem (i18n("Config 4"));
  config_to_activate->setCurrentItem (Configcontainer::preset_config_to_use);
  organizer->addMultiCellWidget (activate, 0, 0, 0, 2);
  myLabel = new QLabel (i18n("Configuration to load:"), this);
  actButton = new QPushButton (i18n("Activate Configuration"), this);
  myNextLabel = new QLabel (i18n("Settings apply to interface:"), this);
  interfaceselector = new QLineEdit (Configcontainer::interface_to_use, this);
  autodetect = new QPushButton (i18n("Autodetect Interface"), this);
  organizer->addRowSpacing (1, config_to_activate->sizeHint ().height ());
  organizer->addWidget (myLabel, 1, 0);
  organizer->addWidget (config_to_activate, 1, 1);
  organizer->addWidget (actButton, 1, 3);
  organizer->addWidget (myNextLabel, 2, 0);
  organizer->addWidget (interfaceselector, 2, 1);
  organizer->addWidget (autodetect, 2, 3);
  organizer->addColSpacing (2, 10);
  setFixedSize (sizeHint ());
  connect (autodetect, SIGNAL (clicked ()), this,
	   SLOT (slotAutodetectInterface ()));
  connect (activate, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));

  connect (actButton, SIGNAL (clicked ()), this, SLOT (slotActivateNow ()));
  connect (config_to_activate, SIGNAL (activated (int)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (interfaceselector, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
}

void
KWifimanager_ConfigWidget2::slotActivateNow ()
{
  bool temp_use_preset = Configcontainer::use_preset_config;
  int temp_preset_config = Configcontainer::preset_config_to_use;
  QString temp_interface = Configcontainer::interface_to_use;
  saveData ();
  emit saveInfoNow ();
  KStandardDirs finder;
  QString kdedir = finder.findResourceDir ("data", "kwifimanager/config/kwifimanagerrc");
  if (kdedir.isEmpty())
     kdedir = finder.findResourceDir ("data","kwifimanager/pics/offline.png")+"kwifimanager/config/";
   else
     kdedir += "kwifimanager/config/";
  QString kde = kdedir;
  KSimpleConfig *conffile = new KSimpleConfig (kde + "kwifimanagerrc", false);
  conffile->setGroup ("General");
  conffile->writeEntry ("Use preset configuration",
			Configcontainer::use_preset_config);
  conffile->writeEntry ("Configuration to use",
			Configcontainer::preset_config_to_use);
  conffile->writeEntry ("Interface", Configcontainer::interface_to_use);
  conffile->sync ();
  emit callInit ();
  emit callChangeConfig (Configcontainer::preset_config_to_use + 1,
			 Configcontainer::interface_to_use);

//  KWifimanager_KCModule::init ();
//  KWifimanager_KCModule::changeConfig (Configcontainer::preset_config_to_use + 1, Configcontainer::interface_to_use);
  conffile->writeEntry ("Use preset configuration", temp_use_preset);
  conffile->writeEntry ("Configuration to use", temp_preset_config);
  conffile->writeEntry ("Interface", temp_interface);
  conffile->sync ();
  delete conffile;
}

void
KWifimanager_ConfigWidget2::saveData ()
{
  Configcontainer::use_preset_config = activate->isChecked ();
  Configcontainer::preset_config_to_use = config_to_activate->currentItem ();
  Configcontainer::interface_to_use = interfaceselector->text ();
}

void
KWifimanager_ConfigWidget2::slotAutodetectInterface ()
{
  // get list of all network interfaces from /proc/net/dev
  QFile procnetdev ("/proc/net/dev");
  procnetdev.open (IO_ReadOnly);
  QStringList liste;
  QString temp = "";
  QString temptrash = "X";
  int end = 1;
  while ((end != 0) && (temp != temptrash))
    {
      end = procnetdev.readLine (temp, 9999);
      temptrash = temp;
      temp.truncate (temp.find (":") > 0 ? temp.find (":") : 0);
      temp = temp.stripWhiteSpace ();
      if ((end != 0) && !temp.isEmpty() )
	liste += temp;
    };
  // now "liste" has all interfaces
  for (QStringList::Iterator it = liste.begin (); it != liste.end (); ++it)
    {
      KProcIO test;
      test << "iwconfig";
      test << *it;
      connect (&test, SIGNAL (readReady (KProcIO *)), this,
	       SLOT (slotTestInterface (KProcIO *)));
      test.start (KProcess::Block);
    };
}

void
KWifimanager_ConfigWidget2::slotTestInterface (KProcIO * proc)
{
  QString tempinput;
  proc->readln (tempinput);
  if (tempinput.find ("no wireless extensions") == -1)
    {
      // this is our WLAN interface
      tempinput.truncate (tempinput.find (" "));
      interfaceselector->setText (tempinput);
    };
}

void
KWifimanager_ConfigWidget2::slotUserChangedSomething ()
{
  emit setChanged (true);
}

void KWifimanager_ConfigWidget2::makeReadOnly()
{
    config_to_activate->setEnabled( false );
    myLabel->setEnabled( false );
    myNextLabel->setEnabled( false );
    activate->setEnabled( false );
    interfaceselector->setEnabled( false );
    autodetect->setEnabled( false );
    actButton->setEnabled( false );
}
