/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * remote.c - remote data support
 */

/*
 * Messages send to xlog should consist of fields, separated by the '\1' character.
 * Fields are started with a descriptor, followed by a colon (':'). Possible fields are:
 *
 ****************************************************************************
 * program:<name of program which sends the QSO information>
 * version:<version string for the message queue, must be '1' for now>
 * date:<date of QSO, preferable 'dd mmm yyyy'>
 * time:<start time of QSO, preferably in GMT >
 * endtime:<end time of QSO, preferably GMT (mandatory in some countries)>
 * call:<callsign of your contact (will be converted to uppercase)>
 * mhz:<frequency in MHz>
 * mode:<any one of CW,SSB,RTTY,PSK31,etc (will be converted to uppercase)>
 * tx:<report (RST) which you have send>
 * rx:<report (RST) which you have received>
 * name:<name of the operator you have contacted>
 * qth:<town of the operator you have contacted>
 * notes:<additional notes>
 * power:<power you have used (mandatory in some countries)>
 * locator:<QRA locator, as used in VHF QSO's>
 * free1: <information to put in freefield1>
 * free2: <information to put in freefield2>
 ****************************************************************************
 *
 * See sendtoxlog.c, included with the sources for examples.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <errno.h>
#include <sys/msg.h>
#include <gtk/gtk.h>
#include "remote.h"
#include "types.h"
#include "log.h"
#include "utils.h"
#include "support.h"

msgtype msgbuf;
remotetype remote;
extern statetype state;
extern preferencestype preferences;
extern glong msgid;
extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern gchar **qso;
extern gchar **bandsplit;
extern gchar **modesplit;
extern GList *logwindowlist;

/* find colon in a string and return the right part */
static gchar *
getargument (gchar * remotestring)
{
  gchar **split, *found = NULL;

  split = g_strsplit (remotestring, ":", 2);
  if (split[1])
    found = g_strdup (split[1]);
  g_strfreev (split);
  return (g_strdup (found));
}

static void
addtolog_or_qsoframe (gint type, gchar * entry)
{
  GtkWidget *menu, *bandoptionmenu, *modeoptionmenu, *active_item, *bandentry,
    *modeentry, *endhbox, *namehbox, *qthhbox, *locatorhbox, *powerhbox,
    *unknown1hbox, *unknown2hbox, *dateentry, *gmtentry, *callentry, *endentry,
    *rstentry, *myrstentry, *powerentry, *nameentry, *qthentry, *locatorentry,
    *unknownentry1, *unknownentry2, *remarksentry, *remarksvbox;
  gchar *temp, **remoteinfo, *argument = NULL, *remarks;
  gint i, j = 0, newrow, bandindex, modeindex;
  logtype *logwindow;

  /* add QSO to the log */
  if (type == 88)
    {
      logwindow = g_list_nth_data (logwindowlist,
				   gtk_notebook_get_current_page (GTK_NOTEBOOK
								  (mainnotebook)));
      /* empty qso array */
      for (i = 0; i < QSO_FIELDS; i++)
	qso[i] = g_strdup ("");
      remarks = g_strdup ("");
      bandentry = lookup_widget (mainwindow, "bandentry");
      bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");
      modeentry = lookup_widget (mainwindow, "modeentry");
      modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
      endhbox = lookup_widget (mainwindow, "endhbox");
      namehbox = lookup_widget (mainwindow, "namehbox");
      qthhbox = lookup_widget (mainwindow, "qthhbox");
      locatorhbox = lookup_widget (mainwindow, "locatorhbox");
      powerhbox = lookup_widget (mainwindow, "powerhbox");
      unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
      unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");

      remoteinfo = g_strsplit (entry, "\1", 0);
      for (;;)
	{
	  if (remoteinfo[j] == NULL)
	    break;
	  if (g_strncasecmp (remoteinfo[j], "version:", 8) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		remote.version = atoi (argument);
	    }
	  else if (g_strncasecmp (remoteinfo[j], "program:", 8) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		remote.program = g_strdup (argument);
	    }
	  else if (g_strncasecmp (remoteinfo[j], "date:", 5) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		qso[DATE] = g_strndup (argument, 15);
	      else
		qso[DATE] = getdate ();
	    }
	  else if (g_strncasecmp (remoteinfo[j], "time:", 5) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		qso[GMT] = g_strndup (argument, 8);
	      else
		qso[GMT] = gettime ();
	    }
	  else if (g_strncasecmp (remoteinfo[j], "call:", 5) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  g_strup (argument);
		  qso[CALL] = g_strndup (argument, 15);
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "mhz:", 4) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		qso[BAND] = g_strndup (argument, 15);
	    }
	  else if (g_strncasecmp (remoteinfo[j], "mode:", 5) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  g_strup (argument);
		  qso[MODE] = g_strndup (argument, 8);
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "tx:", 3) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		qso[RST] = g_strndup (argument, 15);
	    }
	  else if (g_strncasecmp (remoteinfo[j], "rx:", 3) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		qso[MYRST] = g_strndup (argument, 15);
	    }

/* 
 * check if the fields exist for the other remote entries, if not: put them in
 * the remarks fields
 */
	  else if (g_strncasecmp (remoteinfo[j], "endtime:", 8) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (endhbox))
		    qso[GMTEND] = g_strndup (argument, 8);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "name:", 5) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (namehbox))
		    qso[NAME] = g_strndup (argument, 30);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "qth:", 4) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (qthhbox))
		    qso[QTH] = g_strndup (argument, 30);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "notes:", 6) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (g_strcasecmp (remarks, "") == 0)
		    remarks = g_strdup (argument);
		  else
		    remarks = g_strconcat (remarks, ", ", argument, 0);
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "power:", 6) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (powerhbox))
		    qso[POWER] = g_strndup (argument, 8);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "locator:", 8) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (locatorhbox))
		    qso[LOCATOR] = g_strndup (argument, 30);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "free1:", 6) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (unknown1hbox))
		    qso[U1] = g_strndup (argument, 30);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  else if (g_strncasecmp (remoteinfo[j], "free2:", 6) == 0)
	    {
	      if ((argument = getargument (remoteinfo[j])))
		{
		  if (GTK_WIDGET_VISIBLE (unknown2hbox))
		    qso[U2] = g_strndup (argument, 30);
		  else
		    {
		      if (g_strcasecmp (remarks, "") == 0)
			remarks = g_strdup (argument);
		      else
			remarks = g_strconcat (remarks, ", ", argument, 0);
		    }
		}
	    }
	  j++;
	}
      g_strfreev (remoteinfo);
      g_free (argument);

      /* Total length of the remarks field can be 80 characters */
      if (g_strcasecmp (remarks, "") != 0)
	qso[REMARKS] = g_strndup (remarks, 80);
      g_free (remarks);

      /* some checks: if date, gmt, band and mode is unknown we get it from xlog */
      if (g_strcasecmp (qso[DATE], "") == 0)
	qso[DATE] = getdate ();
      if (g_strcasecmp (qso[GMT], "") == 0)
	qso[GMT] = gettime ();
      if (g_strcasecmp (qso[BAND], "") == 0)
	{
	  if (preferences.bandseditbox == 0)
	    {
	      menu = GTK_OPTION_MENU (bandoptionmenu)->menu;
	      active_item = gtk_menu_get_active (GTK_MENU (menu));
	      bandindex =
		g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
	      qso[BAND] = lookup_band (bandsplit[bandindex]);
	    }
	  else
	    qso[BAND] =
	      gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1);
	}
      if (g_strcasecmp (qso[MODE], "") == 0)
	{
	  if (preferences.modeseditbox == 0)
	    {
	      menu = GTK_OPTION_MENU (modeoptionmenu)->menu;
	      active_item = gtk_menu_get_active (GTK_MENU (menu));
	      modeindex =
		g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
	      qso[MODE] = lookup_mode (modesplit[modeindex]);
	    }
	  else
	    qso[MODE] =
	      gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1);
	}

      if (preferences.remoteadding == 1)
      {
        /* add the new QSO to the log */
        qso[NR] = g_strdup_printf ("%d", ++logwindow->qsos);
        newrow = gtk_clist_prepend (GTK_CLIST (logwindow->clist), qso);
        if (preferences.logcolor == 1)
          setcallstyle (logwindow->clist, newrow,
	    preferences.themecolor, preferences.themecolor);
        gtk_label_set_text (GTK_LABEL (logwindow->label),
	  g_strconcat (logwindow->logname, " *", NULL));

        /* get new QSO number and update the statusbar */
        temp =
          g_strdup_printf (_
            ("Remote data received from %s (#%d), QSO %s added"),
              remote.program, ++remote.nr, qso[NR]);
      }
      else
      {  /* add QSO to the QSO frame */
        dateentry = lookup_widget(mainwindow, "dateentry");
        gtk_entry_set_text (GTK_ENTRY (dateentry), qso[DATE]);
        gmtentry = lookup_widget(mainwindow, "gmtentry");
        gtk_entry_set_text (GTK_ENTRY (gmtentry), qso[GMT]);
        if (GTK_WIDGET_VISIBLE (endhbox))
        {
          endentry = lookup_widget(mainwindow, "endentry");
          gtk_entry_set_text (GTK_ENTRY (endentry), qso[GMTEND]);
        }
        callentry = lookup_widget(mainwindow, "callentry");
        gtk_entry_set_text (GTK_ENTRY (callentry), qso[CALL]);
        if (preferences.modeseditbox == 1)
          gtk_entry_set_text (GTK_ENTRY (modeentry), qso[MODE]);
        if (preferences.bandseditbox == 1)
          gtk_entry_set_text (GTK_ENTRY (bandentry), qso[BAND]);
        rstentry = lookup_widget(mainwindow, "rstentry");
        gtk_entry_set_text (GTK_ENTRY (rstentry), qso[RST]);
        myrstentry = lookup_widget(mainwindow, "myrstentry");
        gtk_entry_set_text (GTK_ENTRY (myrstentry), qso[MYRST]);
        if (GTK_WIDGET_VISIBLE (powerhbox))
        {
          powerentry = lookup_widget(mainwindow, "powerentry");
          gtk_entry_set_text (GTK_ENTRY (powerentry), qso[POWER]);
        }
        if (GTK_WIDGET_VISIBLE (namehbox))
        {
          nameentry = lookup_widget(mainwindow, "nameentry");
          gtk_entry_set_text (GTK_ENTRY (nameentry), qso[NAME]);
        }
        if (GTK_WIDGET_VISIBLE (qthhbox))
        {
          qthentry = lookup_widget(mainwindow, "qthentry");
          gtk_entry_set_text (GTK_ENTRY (qthentry), qso[QTH]);
        }
        if (GTK_WIDGET_VISIBLE (locatorhbox))
        {
          locatorentry = lookup_widget(mainwindow, "locatorentry");
          gtk_entry_set_text (GTK_ENTRY (locatorentry), qso[LOCATOR]);
        }
        if (GTK_WIDGET_VISIBLE (unknown1hbox))
        {
          unknownentry1 = lookup_widget(mainwindow, "unknownentry1");
          gtk_entry_set_text (GTK_ENTRY (unknownentry1), qso[U1]);
        }
        if (GTK_WIDGET_VISIBLE (unknown2hbox))
        {
          unknownentry2 = lookup_widget(mainwindow, "unknownentry2");
          gtk_entry_set_text (GTK_ENTRY (unknownentry2), qso[U2]);
        }
        remarksvbox = lookup_widget(mainwindow, "remarksvbox");
        if (GTK_WIDGET_VISIBLE (remarksvbox))
        {
          remarksentry = lookup_widget(mainwindow, "remarksentry");
          gtk_entry_set_text (GTK_ENTRY (remarksentry), qso[REMARKS]);
        }
        temp =
          g_strdup_printf (_
            ("Remote data received from %s (#%d)"),
              remote.program, ++remote.nr);
      }
      update_statusbar (temp);
      g_free (temp);

      /* set some variables */
      remote.program = g_strdup ("unknown");
      remote.version = 0;
      logwindow->logchanged = TRUE;
    }
}

gint
remote_entry (void)
{
  glong msgtyp = 0;
  ssize_t status = -1;

  status =
    msgrcv (msgid, (void *) &msgbuf, 1024, msgtyp, MSG_NOERROR | IPC_NOWAIT);
  if (status != -1)
    addtolog_or_qsoframe (msgbuf.mtype, msgbuf.mtext);
  return 1;
}
