#include "trx.h"
#include "feld.h"
#include "misc.h"
#include "snd.h"
#include "filter.h"
//#include "font.h"

static inline double nco(struct feld *s, double freq)
{
	s->txphacc += 2.0 * M_PI * freq / SampleRate;

	if (s->txphacc > M_PI)
		s->txphacc -= 2.0 * M_PI;

	return cos(s->txphacc);
}

static void tx_char(struct trx *trx, gint c)
{
	struct feld *s = (struct feld *) trx->modem;
	float buf[ColumnLen * 14], f;
	int i, h, w;

	f = trx->frequency;

	/* handle tune signal */
	if (c == -1) {
		for (i = 0; i < ColumnLen * 14; i++)
			buf[i] = nco(s, f);

		sound_write(buf, i);
		return;
	}

	w = 14;
	h = ColumnLen;

#if 0
	/* get font data */
	if (font_get_data(c, buf, &h, &w) < 0)
		return;

	/* filter and modulate */
	for (i = 0; i < w * h; i++) {
		filter_I_run(s->txfilt, buf[i], &buf[i]);
		buf[i] *= nco(s, f);
	}

	/* write to soundcard */
	sound_write(buf, i);

	/* rx echo */
	feld_rxprocess(trx, buf, i);
#endif
}

int feld_txprocess(struct trx *trx)
{
	struct feld *s = (struct feld *) trx->modem;
	int c;

	if (trx->tune) {
		trx->tune = 0;
		s->preamble = 0;
		s->postamble = 0;
		tx_char(trx, -1);
		return 0;
	}

	if (s->preamble-- > 0) {
		tx_char(trx, 46);
		return 0;
	}

	c = trx_get_tx_char();

	/* if TX buffer empty */
	if (c == -1) {
		/* stop if requested to... */
		if (trx->stopflag) {
			if (s->postamble-- > 0) {
				tx_char(trx, 46);
				return 0;
			}
			return -1;
		}

		/* send idle character */
		c = 95;
	}

	tx_char(trx, c);

	return 0;
}
