/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "wrapper-external-exported.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.Panel.External
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:WrapperExternalExported
 * @title: WrapperExternalExported
 * @short_description: Generated C code for the org.xfce.Panel.External D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.xfce.Panel.External ---- */

static const _ExtendedGDBusArgInfo _wrapper_external_exported_method_info_pointer_is_outside_OUT_ARG_is_outside =
{
  {
    -1,
    (gchar *) "is_outside",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _wrapper_external_exported_method_info_pointer_is_outside_OUT_ARG_pointers[] =
{
  &_wrapper_external_exported_method_info_pointer_is_outside_OUT_ARG_is_outside.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _wrapper_external_exported_method_info_pointer_is_outside =
{
  {
    -1,
    (gchar *) "PointerIsOutside",
    NULL,
    (GDBusArgInfo **) &_wrapper_external_exported_method_info_pointer_is_outside_OUT_ARG_pointers,
    NULL
  },
  "handle-pointer-is-outside",
  FALSE
};

static const GDBusMethodInfo * const _wrapper_external_exported_method_info_pointers[] =
{
  &_wrapper_external_exported_method_info_pointer_is_outside.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _wrapper_external_exported_signal_info_set_requisition_ARG_requisition =
{
  {
    -1,
    (gchar *) "requisition",
    (gchar *) "(ii)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _wrapper_external_exported_signal_info_set_requisition_ARG_pointers[] =
{
  &_wrapper_external_exported_signal_info_set_requisition_ARG_requisition.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _wrapper_external_exported_signal_info_set_requisition =
{
  {
    -1,
    (gchar *) "SetRequisition",
    (GDBusArgInfo **) &_wrapper_external_exported_signal_info_set_requisition_ARG_pointers,
    NULL
  },
  "set-requisition"
};

static const _ExtendedGDBusSignalInfo _wrapper_external_exported_signal_info_embedded =
{
  {
    -1,
    (gchar *) "Embedded",
    NULL,
    NULL
  },
  "embedded"
};

static const _ExtendedGDBusSignalInfo _wrapper_external_exported_signal_info_pointer_enter =
{
  {
    -1,
    (gchar *) "PointerEnter",
    NULL,
    NULL
  },
  "pointer-enter"
};

static const _ExtendedGDBusSignalInfo _wrapper_external_exported_signal_info_pointer_leave =
{
  {
    -1,
    (gchar *) "PointerLeave",
    NULL,
    NULL
  },
  "pointer-leave"
};

static const GDBusSignalInfo * const _wrapper_external_exported_signal_info_pointers[] =
{
  &_wrapper_external_exported_signal_info_set_requisition.parent_struct,
  &_wrapper_external_exported_signal_info_embedded.parent_struct,
  &_wrapper_external_exported_signal_info_pointer_enter.parent_struct,
  &_wrapper_external_exported_signal_info_pointer_leave.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _wrapper_external_exported_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.Panel.External",
    (GDBusMethodInfo **) &_wrapper_external_exported_method_info_pointers,
    (GDBusSignalInfo **) &_wrapper_external_exported_signal_info_pointers,
    NULL,
    NULL
  },
  "exported",
};


/**
 * wrapper_external_exported_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
wrapper_external_exported_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct;
}

/**
 * wrapper_external_exported_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #WrapperExternalExported interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
wrapper_external_exported_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * WrapperExternalExported:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link>.
 */

/**
 * WrapperExternalExportedIface:
 * @parent_iface: The parent interface.
 * @handle_pointer_is_outside: Handler for the #WrapperExternalExported::handle-pointer-is-outside signal.
 * @embedded: Handler for the #WrapperExternalExported::embedded signal.
 * @pointer_enter: Handler for the #WrapperExternalExported::pointer-enter signal.
 * @pointer_leave: Handler for the #WrapperExternalExported::pointer-leave signal.
 * @set_requisition: Handler for the #WrapperExternalExported::set-requisition signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link>.
 */

typedef WrapperExternalExportedIface WrapperExternalExportedInterface;
G_DEFINE_INTERFACE (WrapperExternalExported, wrapper_external_exported, G_TYPE_OBJECT)

static void
wrapper_external_exported_default_init (WrapperExternalExportedIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * WrapperExternalExported::handle-pointer-is-outside:
   * @object: A #WrapperExternalExported.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Panel-External.PointerIsOutside">PointerIsOutside()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call wrapper_external_exported_complete_pointer_is_outside() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pointer-is-outside",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (WrapperExternalExportedIface, handle_pointer_is_outside),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * WrapperExternalExported::set-requisition:
   * @object: A #WrapperExternalExported.
   * @arg_requisition: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Panel-External.SetRequisition">"SetRequisition"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("set-requisition",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (WrapperExternalExportedIface, set_requisition),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * WrapperExternalExported::embedded:
   * @object: A #WrapperExternalExported.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Panel-External.Embedded">"Embedded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("embedded",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (WrapperExternalExportedIface, embedded),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * WrapperExternalExported::pointer-enter:
   * @object: A #WrapperExternalExported.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Panel-External.PointerEnter">"PointerEnter"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("pointer-enter",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (WrapperExternalExportedIface, pointer_enter),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * WrapperExternalExported::pointer-leave:
   * @object: A #WrapperExternalExported.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Panel-External.PointerLeave">"PointerLeave"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("pointer-leave",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (WrapperExternalExportedIface, pointer_leave),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * wrapper_external_exported_emit_set_requisition:
 * @object: A #WrapperExternalExported.
 * @arg_requisition: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Panel-External.SetRequisition">"SetRequisition"</link> D-Bus signal.
 */
void
wrapper_external_exported_emit_set_requisition (
    WrapperExternalExported *object,
    GVariant *arg_requisition)
{
  g_signal_emit_by_name (object, "set-requisition", arg_requisition);
}

/**
 * wrapper_external_exported_emit_embedded:
 * @object: A #WrapperExternalExported.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Panel-External.Embedded">"Embedded"</link> D-Bus signal.
 */
void
wrapper_external_exported_emit_embedded (
    WrapperExternalExported *object)
{
  g_signal_emit_by_name (object, "embedded");
}

/**
 * wrapper_external_exported_emit_pointer_enter:
 * @object: A #WrapperExternalExported.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Panel-External.PointerEnter">"PointerEnter"</link> D-Bus signal.
 */
void
wrapper_external_exported_emit_pointer_enter (
    WrapperExternalExported *object)
{
  g_signal_emit_by_name (object, "pointer-enter");
}

/**
 * wrapper_external_exported_emit_pointer_leave:
 * @object: A #WrapperExternalExported.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Panel-External.PointerLeave">"PointerLeave"</link> D-Bus signal.
 */
void
wrapper_external_exported_emit_pointer_leave (
    WrapperExternalExported *object)
{
  g_signal_emit_by_name (object, "pointer-leave");
}

/**
 * wrapper_external_exported_call_pointer_is_outside:
 * @proxy: A #WrapperExternalExportedProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Panel-External.PointerIsOutside">PointerIsOutside()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call wrapper_external_exported_call_pointer_is_outside_finish() to get the result of the operation.
 *
 * See wrapper_external_exported_call_pointer_is_outside_sync() for the synchronous, blocking version of this method.
 */
void
wrapper_external_exported_call_pointer_is_outside (
    WrapperExternalExported *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PointerIsOutside",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * wrapper_external_exported_call_pointer_is_outside_finish:
 * @proxy: A #WrapperExternalExportedProxy.
 * @out_is_outside: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to wrapper_external_exported_call_pointer_is_outside().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with wrapper_external_exported_call_pointer_is_outside().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
wrapper_external_exported_call_pointer_is_outside_finish (
    WrapperExternalExported *proxy,
    gboolean *out_is_outside,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_outside);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * wrapper_external_exported_call_pointer_is_outside_sync:
 * @proxy: A #WrapperExternalExportedProxy.
 * @out_is_outside: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Panel-External.PointerIsOutside">PointerIsOutside()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See wrapper_external_exported_call_pointer_is_outside() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
wrapper_external_exported_call_pointer_is_outside_sync (
    WrapperExternalExported *proxy,
    gboolean *out_is_outside,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PointerIsOutside",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_outside);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * wrapper_external_exported_complete_pointer_is_outside:
 * @object: A #WrapperExternalExported.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_outside: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Panel-External.PointerIsOutside">PointerIsOutside()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
wrapper_external_exported_complete_pointer_is_outside (
    WrapperExternalExported *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_outside)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_outside));
}

/* ------------------------------------------------------------------------ */

/**
 * WrapperExternalExportedProxy:
 *
 * The #WrapperExternalExportedProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * WrapperExternalExportedProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #WrapperExternalExportedProxy.
 */

struct _WrapperExternalExportedProxyPrivate
{
  GData *qdata;
};

static void wrapper_external_exported_proxy_iface_init (WrapperExternalExportedIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (WrapperExternalExportedProxy, wrapper_external_exported_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (WrapperExternalExportedProxy)
                         G_IMPLEMENT_INTERFACE (WRAPPER_EXTERNAL_TYPE_EXPORTED, wrapper_external_exported_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (WrapperExternalExportedProxy, wrapper_external_exported_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (WRAPPER_EXTERNAL_TYPE_EXPORTED, wrapper_external_exported_proxy_iface_init))

#endif
static void
wrapper_external_exported_proxy_finalize (GObject *object)
{
  WrapperExternalExportedProxy *proxy = WRAPPER_EXTERNAL_EXPORTED_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (wrapper_external_exported_proxy_parent_class)->finalize (object);
}

static void
wrapper_external_exported_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
wrapper_external_exported_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
wrapper_external_exported_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], WRAPPER_EXTERNAL_TYPE_EXPORTED);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, WRAPPER_EXTERNAL_TYPE_EXPORTED);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
wrapper_external_exported_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  WrapperExternalExportedProxy *proxy = WRAPPER_EXTERNAL_EXPORTED_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
wrapper_external_exported_proxy_init (WrapperExternalExportedProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = wrapper_external_exported_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, WRAPPER_EXTERNAL_TYPE_EXPORTED_PROXY, WrapperExternalExportedProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), wrapper_external_exported_interface_info ());
}

static void
wrapper_external_exported_proxy_class_init (WrapperExternalExportedProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = wrapper_external_exported_proxy_finalize;
  gobject_class->get_property = wrapper_external_exported_proxy_get_property;
  gobject_class->set_property = wrapper_external_exported_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = wrapper_external_exported_proxy_g_signal;
  proxy_class->g_properties_changed = wrapper_external_exported_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (WrapperExternalExportedProxyPrivate));
#endif
}

static void
wrapper_external_exported_proxy_iface_init (WrapperExternalExportedIface *iface G_GNUC_UNUSED)
{
}

/**
 * wrapper_external_exported_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call wrapper_external_exported_proxy_new_finish() to get the result of the operation.
 *
 * See wrapper_external_exported_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
wrapper_external_exported_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (WRAPPER_EXTERNAL_TYPE_EXPORTED_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Panel.External", NULL);
}

/**
 * wrapper_external_exported_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to wrapper_external_exported_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with wrapper_external_exported_proxy_new().
 *
 * Returns: (transfer full) (type WrapperExternalExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
WrapperExternalExported *
wrapper_external_exported_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return WRAPPER_EXTERNAL_EXPORTED (ret);
  else
    return NULL;
}

/**
 * wrapper_external_exported_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See wrapper_external_exported_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type WrapperExternalExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
WrapperExternalExported *
wrapper_external_exported_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (WRAPPER_EXTERNAL_TYPE_EXPORTED_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Panel.External", NULL);
  if (ret != NULL)
    return WRAPPER_EXTERNAL_EXPORTED (ret);
  else
    return NULL;
}


/**
 * wrapper_external_exported_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like wrapper_external_exported_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call wrapper_external_exported_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See wrapper_external_exported_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
wrapper_external_exported_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (WRAPPER_EXTERNAL_TYPE_EXPORTED_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Panel.External", NULL);
}

/**
 * wrapper_external_exported_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to wrapper_external_exported_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with wrapper_external_exported_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type WrapperExternalExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
WrapperExternalExported *
wrapper_external_exported_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return WRAPPER_EXTERNAL_EXPORTED (ret);
  else
    return NULL;
}

/**
 * wrapper_external_exported_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like wrapper_external_exported_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See wrapper_external_exported_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type WrapperExternalExportedProxy): The constructed proxy object or %NULL if @error is set.
 */
WrapperExternalExported *
wrapper_external_exported_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (WRAPPER_EXTERNAL_TYPE_EXPORTED_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Panel.External", NULL);
  if (ret != NULL)
    return WRAPPER_EXTERNAL_EXPORTED (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * WrapperExternalExportedSkeleton:
 *
 * The #WrapperExternalExportedSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * WrapperExternalExportedSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #WrapperExternalExportedSkeleton.
 */

struct _WrapperExternalExportedSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_wrapper_external_exported_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], WRAPPER_EXTERNAL_TYPE_EXPORTED);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, WRAPPER_EXTERNAL_TYPE_EXPORTED);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_wrapper_external_exported_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_wrapper_external_exported_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_wrapper_external_exported_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _wrapper_external_exported_skeleton_vtable =
{
  _wrapper_external_exported_skeleton_handle_method_call,
  _wrapper_external_exported_skeleton_handle_get_property,
  _wrapper_external_exported_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
wrapper_external_exported_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return wrapper_external_exported_interface_info ();
}

static GDBusInterfaceVTable *
wrapper_external_exported_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_wrapper_external_exported_skeleton_vtable;
}

static GVariant *
wrapper_external_exported_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_wrapper_external_exported_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _wrapper_external_exported_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _wrapper_external_exported_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _wrapper_external_exported_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Panel.External", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
wrapper_external_exported_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_wrapper_external_exported_on_signal_set_requisition (
    WrapperExternalExported *object,
    GVariant *arg_requisition)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@(ii))",
                   arg_requisition));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Panel.External", "SetRequisition",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_wrapper_external_exported_on_signal_embedded (
    WrapperExternalExported *object)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Panel.External", "Embedded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_wrapper_external_exported_on_signal_pointer_enter (
    WrapperExternalExported *object)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Panel.External", "PointerEnter",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_wrapper_external_exported_on_signal_pointer_leave (
    WrapperExternalExported *object)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Panel.External", "PointerLeave",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void wrapper_external_exported_skeleton_iface_init (WrapperExternalExportedIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (WrapperExternalExportedSkeleton, wrapper_external_exported_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (WrapperExternalExportedSkeleton)
                         G_IMPLEMENT_INTERFACE (WRAPPER_EXTERNAL_TYPE_EXPORTED, wrapper_external_exported_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (WrapperExternalExportedSkeleton, wrapper_external_exported_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (WRAPPER_EXTERNAL_TYPE_EXPORTED, wrapper_external_exported_skeleton_iface_init))

#endif
static void
wrapper_external_exported_skeleton_finalize (GObject *object)
{
  WrapperExternalExportedSkeleton *skeleton = WRAPPER_EXTERNAL_EXPORTED_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (wrapper_external_exported_skeleton_parent_class)->finalize (object);
}

static void
wrapper_external_exported_skeleton_init (WrapperExternalExportedSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = wrapper_external_exported_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, WRAPPER_EXTERNAL_TYPE_EXPORTED_SKELETON, WrapperExternalExportedSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
wrapper_external_exported_skeleton_class_init (WrapperExternalExportedSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = wrapper_external_exported_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = wrapper_external_exported_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = wrapper_external_exported_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = wrapper_external_exported_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = wrapper_external_exported_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (WrapperExternalExportedSkeletonPrivate));
#endif
}

static void
wrapper_external_exported_skeleton_iface_init (WrapperExternalExportedIface *iface)
{
  iface->set_requisition = _wrapper_external_exported_on_signal_set_requisition;
  iface->embedded = _wrapper_external_exported_on_signal_embedded;
  iface->pointer_enter = _wrapper_external_exported_on_signal_pointer_enter;
  iface->pointer_leave = _wrapper_external_exported_on_signal_pointer_leave;
}

/**
 * wrapper_external_exported_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Panel-External.top_of_page">org.xfce.Panel.External</link>.
 *
 * Returns: (transfer full) (type WrapperExternalExportedSkeleton): The skeleton object.
 */
WrapperExternalExported *
wrapper_external_exported_skeleton_new (void)
{
  return WRAPPER_EXTERNAL_EXPORTED (g_object_new (WRAPPER_EXTERNAL_TYPE_EXPORTED_SKELETON, NULL));
}

