/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (C) 2009  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libxfce4panel/libxfce4panel.h>
#include <libxfce4util/libxfce4util.h>
#include <config.h>
#include <xfconf/xfconf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libxfcegui4/libxfcegui4.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <popup.h>
#include <gdk/gdk.h>


#define TYPE_NOTES_PLUGIN (notes_plugin_get_type ())
#define NOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTES_PLUGIN, NotesPlugin))
#define NOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTES_PLUGIN, NotesPluginClass))
#define IS_NOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTES_PLUGIN))
#define IS_NOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTES_PLUGIN))
#define NOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTES_PLUGIN, NotesPluginClass))

typedef struct _NotesPlugin NotesPlugin;
typedef struct _NotesPluginClass NotesPluginClass;
typedef struct _NotesPluginPrivate NotesPluginPrivate;

#define XNP_TYPE_APPLICATION (xnp_application_get_type ())
#define XNP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_APPLICATION, XnpApplication))
#define XNP_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_APPLICATION, XnpApplicationClass))
#define XNP_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_APPLICATION))
#define XNP_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_APPLICATION))
#define XNP_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_APPLICATION, XnpApplicationClass))

typedef struct _XnpApplication XnpApplication;
typedef struct _XnpApplicationClass XnpApplicationClass;

struct _NotesPlugin {
	GObject parent_instance;
	NotesPluginPrivate * priv;
};

struct _NotesPluginClass {
	GObjectClass parent_class;
};

struct _NotesPluginPrivate {
	GtkInvisible* invisible;
	GtkButton* button;
	GtkImage* image;
	XfcePanelPlugin* panel_plugin;
	XnpApplication* application;
};


static gpointer notes_plugin_parent_class = NULL;
extern NotesPlugin* plugin;
NotesPlugin* plugin = NULL;

GType notes_plugin_get_type (void);
GType xnp_application_get_type (void);
#define NOTES_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTES_PLUGIN, NotesPluginPrivate))
enum  {
	NOTES_PLUGIN_DUMMY_PROPERTY
};
XnpApplication* xnp_application_new (const char* config_file);
XnpApplication* xnp_application_construct (GType object_type, const char* config_file);
void xnp_application_show_hide_notes (XnpApplication* self);
static void _lambda23_ (NotesPlugin* self);
static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean notes_plugin_set_x_selection (NotesPlugin* self);
static gboolean _lambda25_ (XfcePanelPlugin* p, gint size, NotesPlugin* self);
static gboolean __lambda25__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self);
void xnp_application_save_windows_configuration (XnpApplication* self);
static void _lambda26_ (NotesPlugin* self);
static void __lambda26__xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self);
void xnp_application_save_notes (XnpApplication* self);
static void _lambda27_ (NotesPlugin* self);
static void __lambda27__xfce_panel_plugin_free_data (XfcePanelPlugin* _sender, gpointer self);
void xnp_application_open_settings_dialog (XnpApplication* self);
static void _lambda28_ (NotesPlugin* self);
static void __lambda28__xfce_panel_plugin_configure_plugin (XfcePanelPlugin* _sender, gpointer self);
NotesPlugin* notes_plugin_new (XfcePanelPlugin* panel_plugin);
NotesPlugin* notes_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin);
static gboolean _lambda24_ (GtkInvisible* w, const GdkEventClient* event, NotesPlugin* self);
static gboolean __lambda24__gtk_widget_client_event (GtkInvisible* _sender, const GdkEventClient* event, gpointer self);
static void notes_plugin_finalize (GObject* obj);
void panel_plugin_register (XfcePanelPlugin* panel_plugin);
static void _lambda0_ (void);
static void __lambda0__gcallback (void);
static void _panel_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _lambda23_ (NotesPlugin* self) {
	xnp_application_show_hide_notes (self->priv->application);
}


static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda23_ (self);
}


static gboolean _lambda25_ (XfcePanelPlugin* p, gint size, NotesPlugin* self) {
	gboolean result;
	gint _tmp0_;
	GdkPixbuf* pixbuf;
	g_return_val_if_fail (p != NULL, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->button, size, size);
	_tmp0_ = 0;
	if (gtk_widget_get_style ((GtkWidget*) self->priv->button)->xthickness > gtk_widget_get_style ((GtkWidget*) self->priv->button)->ythickness) {
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->button)->xthickness;
	} else {
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->button)->ythickness;
	}
	size = size - (2 + (2 * _tmp0_));
	pixbuf = xfce_themed_icon_load ("xfce4-notes-plugin", size);
	if (pixbuf == NULL) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = NULL;
		pixbuf = (_tmp1_ = xfce_themed_icon_load (GTK_STOCK_EDIT, size), (pixbuf == NULL) ? NULL : (pixbuf = (g_object_unref (pixbuf), NULL)), _tmp1_);
	}
	gtk_image_set_from_pixbuf (self->priv->image, pixbuf);
	result = TRUE;
	(pixbuf == NULL) ? NULL : (pixbuf = (g_object_unref (pixbuf), NULL));
	return result;
}


static gboolean __lambda25__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self) {
	return _lambda25_ (_sender, size, self);
}


static void _lambda26_ (NotesPlugin* self) {
	xnp_application_save_windows_configuration (self->priv->application);
}


static void __lambda26__xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self) {
	_lambda26_ (self);
}


static void _lambda27_ (NotesPlugin* self) {
	xnp_application_save_windows_configuration (self->priv->application);
	xnp_application_save_notes (self->priv->application);
}


static void __lambda27__xfce_panel_plugin_free_data (XfcePanelPlugin* _sender, gpointer self) {
	_lambda27_ (self);
}


static void _lambda28_ (NotesPlugin* self) {
	xnp_application_open_settings_dialog (self->priv->application);
}


static void __lambda28__xfce_panel_plugin_configure_plugin (XfcePanelPlugin* _sender, gpointer self) {
	_lambda28_ (self);
}


NotesPlugin* notes_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin) {
	GError * _inner_error_;
	NotesPlugin * self;
	XnpApplication* _tmp1_;
	char* _tmp0_;
	GtkButton* _tmp2_;
	GtkImage* _tmp3_;
	g_return_val_if_fail (panel_plugin != NULL, NULL);
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	self->priv->panel_plugin = panel_plugin;
	xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, NULL);
	{
		xfconf_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == XFCONF_ERROR) {
				goto __catch14_xfconf_error;
			}
			goto __finally14;
		}
	}
	goto __finally14;
	__catch14_xfconf_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("main.vala:56: %s", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->application = (_tmp1_ = xnp_application_new (_tmp0_ = xfce_panel_plugin_save_location (panel_plugin, TRUE)), (self->priv->application == NULL) ? NULL : (self->priv->application = (g_object_unref (self->priv->application), NULL)), _tmp1_);
	_tmp0_ = (g_free (_tmp0_), NULL);
	_tmp2_ = NULL;
	self->priv->button = (_tmp2_ = xfce_create_panel_button (), (self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL)), _tmp2_);
	_tmp3_ = NULL;
	self->priv->image = (_tmp3_ = g_object_ref_sink ((GtkImage*) gtk_image_new ()), (self->priv->image == NULL) ? NULL : (self->priv->image = (g_object_unref (self->priv->image), NULL)), _tmp3_);
	gtk_container_add ((GtkContainer*) self->priv->button, (GtkWidget*) self->priv->image);
	g_signal_connect (self->priv->button, "clicked", (GCallback) __lambda23__gtk_button_clicked, self);
	gtk_widget_show_all ((GtkWidget*) self->priv->button);
	gtk_container_add ((GtkContainer*) panel_plugin, (GtkWidget*) self->priv->button);
	xfce_panel_plugin_add_action_widget (panel_plugin, (GtkWidget*) self->priv->button);
	gtk_widget_set_tooltip_text ((GtkWidget*) panel_plugin, _ ("Notes"));
	xfce_panel_plugin_menu_show_configure (panel_plugin);
	notes_plugin_set_x_selection (self);
	g_signal_connect (panel_plugin, "size-changed", (GCallback) __lambda25__xfce_panel_plugin_size_changed, self);
	g_signal_connect (panel_plugin, "save", (GCallback) __lambda26__xfce_panel_plugin_save, self);
	g_signal_connect (panel_plugin, "free-data", (GCallback) __lambda27__xfce_panel_plugin_free_data, self);
	g_signal_connect (panel_plugin, "configure-plugin", (GCallback) __lambda28__xfce_panel_plugin_configure_plugin, self);
	return self;
}


NotesPlugin* notes_plugin_new (XfcePanelPlugin* panel_plugin) {
	return notes_plugin_construct (TYPE_NOTES_PLUGIN, panel_plugin);
}


static gboolean _lambda24_ (GtkInvisible* w, const GdkEventClient* event, NotesPlugin* self) {
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	if (_vala_strcmp0 (popup_get_message_from_event (&(*event)), "SHOW_HIDE") == 0) {
		xnp_application_show_hide_notes (self->priv->application);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda24__gtk_widget_client_event (GtkInvisible* _sender, const GdkEventClient* event, gpointer self) {
	return _lambda24_ (_sender, event, self);
}


/**
 * set_x_selection:
 *
 * Set an X selection to listen to for the popup command.
 */
static gboolean notes_plugin_set_x_selection (NotesPlugin* self) {
	gboolean result;
	GtkInvisible* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = NULL;
	self->priv->invisible = (_tmp0_ = g_object_ref_sink ((GtkInvisible*) gtk_invisible_new ()), (self->priv->invisible == NULL) ? NULL : (self->priv->invisible = (g_object_unref (self->priv->invisible), NULL)), _tmp0_);
	if (!popup_set_x_selection ((GtkWidget*) self->priv->invisible)) {
		result = FALSE;
		return result;
	}
	g_signal_connect ((GtkWidget*) self->priv->invisible, "client-event", (GCallback) __lambda24__gtk_widget_client_event, self);
	result = TRUE;
	return result;
}


static void notes_plugin_class_init (NotesPluginClass * klass) {
	notes_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotesPluginPrivate));
	G_OBJECT_CLASS (klass)->finalize = notes_plugin_finalize;
}


static void notes_plugin_instance_init (NotesPlugin * self) {
	self->priv = NOTES_PLUGIN_GET_PRIVATE (self);
}


static void notes_plugin_finalize (GObject* obj) {
	NotesPlugin * self;
	self = NOTES_PLUGIN (obj);
	{
		XnpApplication* _tmp0_;
		/* Destroy application before calling Xfconf.shutdown()*/
		_tmp0_ = NULL;
		self->priv->application = (_tmp0_ = NULL, (self->priv->application == NULL) ? NULL : (self->priv->application = (g_object_unref (self->priv->application), NULL)), _tmp0_);
		xfconf_shutdown ();
	}
	(self->priv->invisible == NULL) ? NULL : (self->priv->invisible = (g_object_unref (self->priv->invisible), NULL));
	(self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL));
	(self->priv->image == NULL) ? NULL : (self->priv->image = (g_object_unref (self->priv->image), NULL));
	(self->priv->application == NULL) ? NULL : (self->priv->application = (g_object_unref (self->priv->application), NULL));
	G_OBJECT_CLASS (notes_plugin_parent_class)->finalize (obj);
}


GType notes_plugin_get_type (void) {
	static GType notes_plugin_type_id = 0;
	if (notes_plugin_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (NotesPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notes_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotesPlugin), 0, (GInstanceInitFunc) notes_plugin_instance_init, NULL };
		notes_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "NotesPlugin", &g_define_type_info, 0);
	}
	return notes_plugin_type_id;
}


void panel_plugin_register (XfcePanelPlugin* panel_plugin) {
	NotesPlugin* _tmp0_;
	g_return_if_fail (panel_plugin != NULL);
	_tmp0_ = NULL;
	plugin = (_tmp0_ = notes_plugin_new (panel_plugin), (plugin == NULL) ? NULL : (plugin = (g_object_unref (plugin), NULL)), _tmp0_);
}


static void _lambda0_ (void) {
	gtk_main_quit ();
}


static void __lambda0__gcallback (void) {
	_lambda0_ ();
}


static gint xfce_PanelPluginRegisterExternalFull (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_, XfcePanelPluginPreInit preinit, XfcePanelPluginCheck check) {
	gint result;
	XfceExternalPanelPlugin* panel_plugin;
	if (preinit != NULL) {
		if (!preinit (*argv_length1, (*argv))) {
			result = 3;
			return result;
		}
	}
	gtk_init (&(*argv_length1), &(*argv));
	if (check != NULL) {
		if (!check (gdk_screen_get_default ())) {
			result = 2;
			return result;
		}
	}
	panel_plugin = g_object_ref_sink (xfce_external_panel_plugin_new (*argv_length1, (*argv), _register_));
	if (panel_plugin == NULL) {
		result = 1;
		(panel_plugin == NULL) ? NULL : (panel_plugin = (g_object_unref (panel_plugin), NULL));
		return result;
	}
	g_signal_connect_after (panel_plugin, "destroy", __lambda0__gcallback, NULL);
	gtk_widget_show ((GtkWidget*) panel_plugin);
	gtk_main ();
	result = 0;
	(panel_plugin == NULL) ? NULL : (panel_plugin = (g_object_unref (panel_plugin), NULL));
	return result;
}


static gint xfce_PanelPluginRegisterExternal (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_) {
	gint result;
	result = xfce_PanelPluginRegisterExternalFull (&(*argv_length1), &(*argv), _register_, NULL, NULL);
	return result;
}


static void _panel_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin) {
	panel_plugin_register (panel_plugin);
}


gint _main (char** args, int args_length1) {
	gint result;
	result = xfce_PanelPluginRegisterExternal (&args_length1, &args, _panel_plugin_register_xfce_panel_plugin_func);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




