/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <limits.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "icons.h"
#include "misc.h"



/************* routines for dummies ***********************/
static char *dummy_mess(int records, int total_files)
{
    static char load_mess[_POSIX_PATH_MAX];
    char *s;

    switch (records)
    {
	case -1:
	    s = g_strdup(_("Reading..."));
	    break;
	case -2:
	    s = g_strdup(_("Sorting..."));
	    break;
	case -3:
	    s = g_strdup(_("Load failed"));
	    break;
	case -4:
	    s = g_strdup(_("Nothing searched"));
	    break;
	case -5:
	    s = g_strdup(_("Use drag+drop to add"));
	    break;
	case -6:
	    s = g_strdup(_("Nothing found"));
	    break;
	case -7:
	    s = g_strdup("..");
	    break;
	case -8:
	    s = g_strdup(_("No usable Xfce4 panel configuration"));
	    break;
	default :
	    s = g_strdup(_("Loading..."));
	    break;
    }

    if(strlen(s) + 32 > 255)
	g_assert_not_reached();
    if(records >= 0)
    {
	if(records && total_files)
	    sprintf(load_mess, "%s %d/%d", s, records, total_files);
	else if(records)
	    sprintf(load_mess, "%s %d", s, records);
	else
	    sprintf(load_mess, "%s", s);
    }
    else
	sprintf(load_mess, "%s", s);
    g_free(s);
    return load_mess;
}

void erase_dummy(GtkTreeView * treeview, GtkTreeIter * target)
{
    GtkTreeIter iter;
    GtkTreeModel *treemodel;
    tree_entry_t *en;
    treemodel = gtk_tree_view_get_model(treeview);
    if(gtk_tree_model_iter_children(treemodel, &iter, target))
    {
	en = get_entry(treeview, &iter);
	if(IS_DUMMY_TYPE(en->type))
	{
	    gtk_tree_store_remove((GtkTreeStore *) treemodel, &(iter));
	}
	else
	{
	    while(gtk_tree_model_iter_next(treemodel, &iter))
	    {
		en = get_entry(treeview, &iter);
		if(IS_DUMMY_TYPE(en->type))
		{
		    gtk_tree_store_remove((GtkTreeStore *) treemodel, &(iter));
		    break;
		}
	    }
	}
    }
    return;
}

void reset_dummy_by_model(GtkTreeModel * treemodel, GtkTreeIter * target, int dummy_code)
{
    GtkTreeIter iter;
    tree_entry_t *en;
    GdkPixbuf *Icon;
    char *text;

    switch (dummy_code)
    {
	case 0:
	    Icon = icon_tell(0, "xf_WARNING_ICON");
	    text = dummy_mess(0, 0);
	    break;
	case 1:
	    Icon = NULL;	/*icon_tell(0,INFO_ICON); */
	    text = "";	     
	    break;
	case 2:
	    Icon = icon_tell(0, "xf_INFO_ICON");
	    text = dummy_mess(-4, 0);
	    break;
	case 3:
	    Icon = icon_tell(0, "xf_INFO_ICON");
	    text = dummy_mess(-5, 0);
	    break;
	case -3:
	    Icon = icon_tell(0, "xf_ERROR_ICON");
	    text = dummy_mess(dummy_code, 0);
	    break;
	case 4:
	    Icon = icon_tell(0, "xf_INFO_ICON");
	    text = dummy_mess(-6, 0);
	    break;
	case 5:
	    Icon = icon_tell(0, "xf_UP_ICON");
	    text = dummy_mess(-7, 0);
	    break;
	case -8:
	    Icon = icon_tell(0, "xf_ERROR_ICON");
	    text = dummy_mess(dummy_code, 0);
	    break;
	default:
	    Icon = icon_tell(0, "xf_NOACCESS_ICON");
	    text = "";
	    break;
    }
    if(gtk_tree_model_iter_children(treemodel, &iter, target))
    {
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	if(IS_DUMMY_TYPE(en->type))
	{
	    gtk_tree_store_set((GtkTreeStore *) treemodel, &(iter), 
			    PIXBUF_COLUMN, Icon, 
			    NAME_COLUMN, my_utf_string(text), -1);
	    if(dummy_code == 5)
	    {
		if(en->path)
		    g_free(en->path);
		en->path = g_strdup("..");
	    }
	}
    }
}

void reset_dummy(GtkTreeView * treeview, GtkTreeIter * target, int dummy_code)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    reset_dummy_by_model(treemodel, target, dummy_code);
}

void update_dummy_by_model(GtkTreeModel * treemodel, GtkTreeIter * target, int records, int total_files)
{
    GtkTreeIter dummy;
    if(gtk_tree_model_iter_children(treemodel, &dummy, target))
    {
	tree_entry_t *en;
	gtk_tree_model_get(treemodel, &dummy, ENTRY_COLUMN, &en, -1);
	if(IS_DUMMY_TYPE(en->type))
	    gtk_tree_store_set((GtkTreeStore *) treemodel, &(dummy), 
		 NAME_COLUMN, my_utf_string(dummy_mess(records, total_files)), 
		-1);
    }
}

/* watchout, this routine enters and leaves the tree in frozen state */
void update_dummy(GtkTreeView * treeview, GtkTreeIter * target, int records, int total_files)
{
    static time_t last = 0;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    if(records < 0)
    {
	if(time(NULL) - last < 1)
	    return;		/* avoid flashing */
	else
	    last = time(NULL);
    }

    update_dummy_by_model(treemodel, target, records, total_files);

    gtk_widget_thaw_child_notify((GtkWidget *) treeview);
    process_pending_gtk();
    gtk_widget_freeze_child_notify((GtkWidget *) treeview);
}

GtkTreeIter add_dummy_by_model(GtkTreeModel * treemodel, GtkTreeIter * iterator)
{
    GtkTreeIter dummy;
    tree_entry_t *p_en, *en;

    gtk_tree_model_get(treemodel, iterator, ENTRY_COLUMN, &p_en, -1);
    en = mk_entry(p_en->type);
    SET_DUMMY_TYPE(en->type);
    gtk_tree_store_prepend((GtkTreeStore *) treemodel, &dummy, iterator);
    gtk_tree_store_set((GtkTreeStore *) treemodel, &dummy, 
	PIXBUF_COLUMN, icon_tell(0, "xf_WARNING_ICON"), 
	STYLE_COLUMN, PANGO_STYLE_ITALIC, 
	NAME_COLUMN, my_utf_string(dummy_mess(0, 0)), 
	ENTRY_COLUMN, en, -1);
    return dummy;
}


GtkTreeIter add_dummy(GtkTreeView * treeview, GtkTreeIter * iterator)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    return add_dummy_by_model(treemodel, iterator);
}
