/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "terminal.h"
#include "misc.h"
#include "run.h"


static void new_terminal(GtkTreeView * treeview)
{
    char *argv[20];
    int i=0;
    gchar *term=NULL;
    argv[i++]="xterm";
    if (getenv("TERM") && strlen( getenv("TERM"))){
		gchar *c,*t=g_strdup(getenv("TERM"));
    		t=g_strstrip(t);
		if (strchr(t,' '))t=strtok(t," ");
		c=g_find_program_in_path(t);
		if (c && access(c,X_OK)==0) {
		  term = g_strdup(getenv("TERM"));
		} else term = NULL;
		g_free(c);
		g_free(t);
    }
    if (!term) term=g_strdup("xterm +mesg -aw +cm +dc -j -rightbar -s -sb -u8 -wf -sl 1024");
    on_run(treeview,term,NULL, FALSE, FALSE, FALSE);
    g_free(term);
    return;
}

/* callbacks */

void on_terminal2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    new_terminal(treeview);
}

void tb_terminal(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    new_terminal(treeview);
}

void on_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    new_terminal(treeview);
}
