/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "print.h"
#include "input.h"
#include "misc.h"
#include "run.h"
#include "tubo.h"
#include "widgets.h"


int print_it(GtkTreeView * treeview, GtkTreeIter * iter, char *cmd, char *file)
{
    char *argv[3];
    if(!file) g_assert_not_reached();

    argv[0]=cmd;
    argv[1]=file;
    argv[2]=0;
    return runv(treeview,argv);
}

void on_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeIter iter;
    gchar *t=g_find_program_in_path("xfprint4");
    en = get_selected_entry(treeview, &iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(treeview, "xf_ERROR_ICON", strerror(EINVAL), NULL);
	return;
    }
    if (t) {
	    print_it(treeview,NULL,t,en->path);
	    g_free(t);
    } else {
	    show_input(treeview, PRINT_INPUT);
    }

}

void tb_print(GtkButton * button, gpointer user_data)
{
    on_print_activate((GtkMenuItem *) button, user_data);
}


void
on_printer_configuration_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
   char *argv[2];
   argv[0]="xfprint-manager";
   argv[1]=0;
   runv(treeview, argv);
}

