/* copywrite 2001-2003 edscott wilson garcia under GNU/GPL 
 * 
 *  pasteboard routines for xffm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "aux.h"
#include "bookmarks.h"
#include "cpy.h"
#include "dnd.h"
#include "entry.h"
#include "icons.h"
#include "misc.h"
#include "smb_misc.h"
#include "monitor.h"
#include "run.h"
#include "smb_download.h"
#include "uri.h"
#include "widgets.h"


#define CUT_BUFFER 0

extern gboolean tar_extraction;
extern char *src_host;

static GList *paste_list = NULL;
char *pastepath;
GtkTreeRowReference *pasteref;

int valid_pasteboard(void)
{
    int ret = 0, len = -1;
    char *b;
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if((!b) || (!strlen(b)))
	ret = 0;
    else if(strncmp(b, "#xfvalid_buffer:copy", strlen("#xfvalid_buffer:copy")) == 0)
	ret = 1;
    else if(strncmp(b, "#xfvalid_buffer:cut", strlen("#xfvalid_buffer:cut")) == 0)
	ret = 2;

#ifdef DEBUG
    printf("DBG:paste buffer:\n%s\n",b); 
#endif
    XFree(b);
    return ret;
}

gboolean in_pasteboard(tree_entry_t *en)
{
    int len = -1;
    char *b, *search,*path;
    static char *files=NULL;

    if(!en || !en->path) return FALSE;
    if (IS_ROOT_TYPE(en->type)&&!IS_LOCAL_TYPE(en->type)) return FALSE;
    if (__XF_MASK&en->subtype) return FALSE;
    
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    if((!b) || (!strlen(b))) goto not_here;

    if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)){
	char *server,*remote_file;
	if (files) g_free(files);
	server=g_strdup(en->path+2);
	strtok(server,"/");
	remote_file=server+strlen(server)+1;
	files=(char *)malloc(strlen(server)+
			strlen(remote_file)+
			strlen(en->tag)+
			strlen("smb://@://\n")+1);
	if (IS_NETDIR(en->subtype))
		sprintf (files, "%s://%s@%s:%s/",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	else
		sprintf (files, "%s://%s@%s:%s",
		  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
		  (en->tag)?en->tag:"GUEST%%",
		  server,remote_file);
	
	g_free(server);
	path=files;
    }
    else path=en->path;
    
    search = strtok(b, "\n");
    if (!search) return FALSE;
    if (strncmp(search, "#xfvalid_buffer", strlen("#xfvalid_buffer")) != 0)
	    return FALSE;
    search = strtok(NULL,"\n");
    while(search)
    {
	if(strcmp(search, path) == 0) {
	    XFree(b);
	    return TRUE;
	}
	search = strtok(NULL, "\n");
    }
  not_here:
    XFree(b);
    return FALSE;
}

static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_entry_t *en = get_entry(treeview, iter);

    if(!en){
#ifdef DEBUG
	printf("DBG: on check_select for pasteboard, entry is null!\n");
#endif
	return;
    }
    if(IS_DUMMY_TYPE(en->type))
	return;
    if(!IS_PATH(en->type)&&!IS_NETTHING(en->subtype))
	return;
    paste_list = g_list_append(paste_list, en);
    return;
}

static void tag_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;

    set_icon(treeview, iter);
    return;
}


void cb_clean_pasteboard(GtkTreeView * treeview)
{
    XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);	/* store a null string */
    turn_on_pasteboard(treeview);
    return;
}

static void copy_cut(GtkTreeView * treeview, gboolean cut)
{
    int len;
    char *buffer,*files;
    GList *tmp;

    if(!paste_list || !g_list_length(paste_list)){
	print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME:Nothing to copy/cut!\n",
		NULL);
   
	return;
    }
    len = 1 + strlen("#xfvalid_buffer:copy:%%:\n");
    len += strlen(our_host_name(treeview));
    for(tmp = paste_list; tmp; tmp = tmp->next)
    {
	int addlen;
	tree_entry_t *en=(tree_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		addlen=strlen("smb://@://\n");
		addlen += ((en->tag)?strlen(en->tag):strlen("GUEST%%"));
	} else addlen=0;
	len += (1 + strlen(en->path)+addlen);
    }
    buffer = (char *)malloc(len * sizeof(char) + 1);
    if(!buffer)
    {
	printf("xffm: unable to allocate paste buffer\n");
	g_assert_not_reached();
    }
    sprintf(buffer, "#xfvalid_buffer:%s:%s:\n", (cut) ? "cut" : "copy", our_host_name(treeview));
    files=buffer+ strlen(buffer);
    for(tmp = paste_list; tmp; tmp = tmp->next)
    {
	tree_entry_t *en=(tree_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		char *server,*remote_file;
		server=g_strdup(en->path+2);
		strtok(server,"/");
		if (IS_XF_NETWS(en->subtype)) {
			sprintf (files, "%s://%s@%s:",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server);
		} else {
		  	remote_file=server+strlen(server)+1;
		  	sprintf (files, "%s://%s@%s:%s%s",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server,remote_file,
			  (IS_NETDIR(en->subtype))?"/\n":"\n");
		}
		g_free(server);
	        files = files + strlen(files);
		
	} else {
	  strcat(buffer, en->path);
	  strcat(buffer, "\n");
	}
    }
    /*printf("dbg:len=%d,strlen=%d,data=%s\n",len,strlen(buffer),buffer); */
    XStoreBuffer(GDK_DISPLAY(), buffer, len, CUT_BUFFER);
    g_free(buffer);


    g_list_free(paste_list);
    paste_list = NULL;
    {
	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
	gtk_tree_selection_selected_foreach(selection, tag_select, (gpointer) treeview);
	gtk_tree_selection_unselect_all(selection);
    process_pending_gtk();

    }

    turn_on(treeview);
    local_monitor(treeview,TRUE);
}

/* this is equivalent to copying by dnd */

static void cb_paste(GtkTreeView * treeview)
{
    uri *u;
    gboolean cut;
    GList *list, *flist, *tmp;
    tree_entry_t *t_en = NULL;
    char *tmpfile, *b=NULL, *word;
    int i, len = -1;
    GtkTreeIter iter;
    tree_details_t *tree_details = get_tree_details(treeview);
    gboolean will_expand=FALSE;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    if(!pastepath){
	print_status(treeview, 
			"xf_ERROR_ICON", "FIXME: null pastepath!\n", NULL);
	return;
    }
    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if((!b) || (!strlen(b)))
    {
no_pasteboard:
	print_status(treeview, "xf_ERROR_ICON", _("The pasteboard is currently empty."), NULL);
	if(b)
	    XFree(b);
	return;
    }

    if((word = strtok(b, ":")) == NULL)
    {
	goto no_pasteboard;	
    }
    if(!strstr(word, "#xfvalid_buffer")){
	/* this happens if another application also uses the X clipboard */
	goto no_pasteboard;	
    }
    if((word = strtok(NULL, ":")) == NULL)
    {
	goto no_pasteboard;	
    }
    if(strstr(word, "cut"))
	cut = TRUE;
    else
	cut = FALSE;
    if((word = strtok(NULL, ":")) == NULL)
    {
	goto no_pasteboard;	
    }
    if(!word)
    {
	print_status(treeview, "xf_WARNING_ICON", _("source host was not specified."), "\n", NULL);
	XFree(b);
	return;
    }
    src_host = g_strdup(word);

    word = word + strlen(word) + 1;
    if(word[0] == '\n')
    {
	word++;
	if(word[0] == 0) goto no_pasteboard;	
    }
    else
    {
	if((word = strtok(NULL, "\n")) == NULL) goto no_pasteboard;
	word = word + strlen(word) + 1;
    }


    /* create list to send to CreateTmpList */
    i = uri_parse_list(word, &list);
    flist = list;		/* keep initial pointer to later free the list */
    u = list->data;
    if(!i) goto no_pasteboard;	
    XFree(b);			/* no longer needed here */

#ifdef DEBUG
	printf("DBG:pastepath=%s\n",pastepath);
#endif
    if (!get_selected_entry(treeview,&iter)){
	    print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME: cannot get selection, pastepath= ",
		pastepath,"\n",NULL);
	    return;
    }
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &t_en, -1);
    if (!t_en) {
	print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME:cannot get target information, pastepath= ",
		pastepath,"\n",NULL);
    	return;
    }

    
    {
 	GtkTreePath *treepath=gtk_tree_model_get_path(treemodel,&iter);
    	pasteref=gtk_tree_row_reference_new(treemodel,treepath);
    	gtk_tree_path_free(treepath);
    }	
    if (IS_EXPANDED(t_en->type)) will_expand=TRUE;
    if(strcmp(pastepath, "ROOT_BOOKMARKS") != 0)
    {
	if (strncmp(pastepath,"//",2)==0){
#ifdef DEBUG
	  printf("DBG:pastepath=%s,en->path=%s\n",pastepath,t_en?
			  t_en->path:"null");
#endif
	  
	} else {
	  if(access(pastepath, X_OK) != 0)
	  {
	    list = uri_free_list(flist);
	    print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME:Cancelling paste, cannot list ",
		pastepath,"\n",
		NULL);
	    
	    return;
	  }
	  /*if(access(pastepath, W_OK) != 0)
	  {
	    list = uri_free_list(flist);
	    return;
	  }*/
#if 0
	  SET_LOCAL_TYPE(type);
	  t_en = stat_entry(pastepath, type);
#endif
	  if (IS_DIR(t_en->type) && access(pastepath, W_OK) != 0)
	  {
	    list = uri_free_list(flist);
	    print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME:Cancelling paste, cannot write to ",
		pastepath,"\n",
		NULL);
	    return;
	  }
	  if (IS_EXE(t_en->type) && !IS_DIR(t_en->type)){
		SET_APP_TYPE(t_en->type);
		
	  }
    	  if(u->type == URI_SMB)
    	  {				/* src_host may be remote or local  
				   but target only local  or bookmark */
            if (IS_DIR(t_en->type)){	    
	      SMBGetFile(treeview, t_en->path, list);
            }
	    goto paste_done;
	  }
	} 
    }

    if(!set_load_wait(&tree_details))
    {
	print_status(treeview, 
		"xf_ERROR_ICON",
		"FIXME:Cancelling paste, treeview is busy (please retry)\n",
		NULL);
	return;
    }



    if(IS_NETDIR(t_en->subtype) || 
	 IS_XF_NETSHARE(t_en->subtype)|| 
	 IS_NETFILE(t_en->subtype) 
      )
    {
      gchar *target;
       
      if (IS_XF_NETSHARE(t_en->subtype)){
        target=g_strdup("/"); 	    
      } else {
	char *p;
	p=strstr(t_en->path+2,"/")+1;
	target=g_strdup(strstr(p,"/"));
        if (IS_NETFILE(t_en->subtype)) *strrchr(target,'/')=0;
      } 
#ifdef DEBUG
      printf("DBG:paste target=%s\n",target);
#endif
      
      tmpfile=CreateSMBTmpList(treeview,list,target,
		      IS_SAMBA_SERVER(t_en->subtype));
      g_free(target);
      if (!tmpfile) goto paste_done;
      SMBDropFile (treeview,t_en,&iter,tmpfile);
      goto paste_done;
    }

    /* single command line for rsync not possible, only for scp! */
    if(strcmp(src_host, our_host_name(treeview)) != 0)
    {
	int l = 0;
	char **srcs;
	for(tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    l++;
	}
	srcs = (char **)malloc(l * sizeof(char *));
	if(!srcs){
	    printf("xffm: %s at malloc\n",strerror(errno));
	    g_assert_not_reached();
	}
	srcs[l] = NULL;
	for(l = 0, tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    u = tmp->data;
	    srcs[l] = u->url;
	    srcs[l + 1] = NULL;
	    /* with rsync, one by one */
	    if(tree_details->preferences & RSYNC_X_SCP)
	    {
		rsync(treeview, srcs + l, t_en->path);
	    }
	    l++;
	}
	if(!(tree_details->preferences & RSYNC_X_SCP))
	    rsync(treeview, srcs, t_en->path);
	goto paste_done;
    }
    if(strcmp(pastepath, "ROOT_BOOKMARKS") == 0)
    {
	for(tmp = list; tmp; tmp = tmp->next)
	{
	    u = tmp->data;
	    add2bookmarks(treeview, u->url);
	}
	goto paste_done;
    }    
    else if (IS_APP_TYPE(t_en->type)) {
	char *argv[3];
	print_status(treeview, "xf_INFO_ICON", 
			       _("Executing"), " : ", 
			        FILENAME(t_en), 
			       NULL);
	argv[0]=t_en->path;
	argv[2]=0;
	
	for(tmp = list; tmp; tmp = tmp->next)
	{
	    u = tmp->data;
	    argv[1]=u->url;
	    runv(treeview, argv);
	}
	goto paste_done;
    }
    else {
	tmpfile = CreateTmpList(treeview, list, t_en);
	/*fprintf(stderr,"dbg:tmpfile=%s\n",tmpfile); */
	if(tmpfile)
	{
	    if(tar_extraction)
	    {
		/* DirectTransfer(treeview,(cut)?TR_MOVE:TR_COPY,tmpfile);*/
	    }
	    else
	    {
		if((cut) && (on_same_device()))
		{
		    DirectTransfer(treeview, TR_MOVE, tmpfile);
		}
		else
		{
		    IndirectTransfer(treeview, (cut) ? TR_MOVE : TR_COPY, tmpfile);
		}
	    }
	    unlink(tmpfile);
	}
    }

  paste_done:

    list = uri_free_list(flist);
    update_dir(treeview, pasteref);

    /* crash, duh if(t_en && !IS_NETTHING(t_en->subtype)) destroy_entry(t_en);*/
    if(cut)
	XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);
    turn_on_pasteboard(treeview);
    unset_load_wait(&tree_details);
    if (will_expand && (IS_NETDIR(t_en->subtype) || 
			IS_XF_NETSHARE(t_en->subtype)||  
			IS_NETFILE(t_en->subtype)) )

    {
	GtkTreePath *treepath=gtk_tree_row_reference_get_path(pasteref);
    	gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	gtk_tree_path_free(treepath);
    }
    hide_stop(tree_details->window);
    return;
}

void cb_paste_show(GtkTreeView * treeview)
{
    char *b, *word;
    int len = -1;
    char *mess[] = {
	N_("Pasteboard cut"),
	N_("Pasteboard copy")
    };

    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if(b && strlen(b))
    {
	print_diagnostics(treeview, "xf_INFO_ICON", NULL);
	word = b;
	if(valid_pasteboard())
	{
	    strtok(b, ":");
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		if(strcmp(word, "cut") == 0)
		    print_diagnostics(treeview, NULL, _(mess[0]), " :\n", NULL);
		else
		    print_diagnostics(treeview, NULL, _(mess[1]), " :\n", NULL);
	    }
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		print_diagnostics(treeview, NULL, " ", _("from host"), " ", word, " :\n", NULL);
	    }
	    word += (strlen(word) + 1);
	    if (strstr(word,"smb://")) ascii_readable(word);
	    /* my guess is that SMB:// need not ascii readable, since
	     * its a Samba server */
	}
	print_diagnostics(treeview, NULL, word, "\n", NULL);
    }
    else
    {
	print_diagnostics(treeview, "xf_ERROR_ICON", _("The pasteboard is currently empty."), "\n", NULL);
    }

    XFree(b);
    return;
}



static GtkTreeView *get_the_pasteboard_list(GtkWidget *w){
    GtkTreeSelection *selection;
    GtkTreeView *treeview=get_selected_treeview(w);
    if (!treeview) return NULL;
    selection = gtk_tree_view_get_selection(treeview);
     /* get selection */
    if(paste_list) {
	g_list_free(paste_list);
	paste_list = NULL;
    }
    gtk_tree_selection_selected_foreach(selection, check_select, (gpointer) treeview);
    if (paste_list) return treeview;
    return NULL;
}

/*   callbacks   */

void on_cut_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list((GtkWidget *) menuitem);
    if (!treeview) return;
    copy_cut(treeview, TRUE);
    turn_on_pasteboard(treeview); 
    return;
}


void on_copy_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list((GtkWidget *) menuitem);
    if (!treeview) return;
    copy_cut(treeview, FALSE);
    turn_on_pasteboard(treeview);
    return;
}


void on_paste_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_selected_treeview((GtkWidget *) menuitem);
    if (!treeview) return;
    cb_paste(treeview);
    turn_on_pasteboard(treeview);
    return;
}


void on_list_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    cb_paste_show(treeview);

}


void on_clear_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    cb_clean_pasteboard(treeview);
    turn_on_pasteboard(treeview);

}



void tb_cut(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list((GtkWidget *)button);
    if (!treeview) return;
    copy_cut(treeview, TRUE);
    turn_on_pasteboard(treeview);
    return;

}


void tb_copy(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_the_pasteboard_list((GtkWidget *)button);
    if (!treeview) return;
    copy_cut(treeview, FALSE);
    turn_on_pasteboard(treeview);
    return;

}


void tb_paste(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview=NULL;
    treeview=get_selected_treeview((GtkWidget *) button);
    if (!treeview) return;
    cb_paste(treeview);
    turn_on_pasteboard(treeview);
    return;

}
