/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The XFC Development Team.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/// @file xfc/gtk/iconthemesignals.hh
/// @brief Gtk::IconTheme virtual signal handlers.
///
/// Provides Gtk::IconThemeSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::IconTheme objects.

#ifndef XFC_GTK_ICON_THEME_SIGNALS_HH
#define XFC_GTK_ICON_THEME_SIGNALS_HH

#ifndef XFC_G_OBJECT_SIGNALS_HH
#include <xfc/glib/objectsignals.hh>
#endif

namespace Xfc {

namespace Gtk {

/// @class IconThemeSignals iconthemesignals.hh xfc/gtk/iconthemesignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::IconTheme.

class IconThemeSignals : public G::ObjectSignals
{
protected:
/// @name Constructors
/// @{

	IconThemeSignals(IconTheme *icon_theme);
	///< Construct a new IconThemeSignals object.
	///< @param icon_theme A IconTheme object inheriting the IconThemeSignals implementation.

	virtual ~IconThemeSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_changed();
	///< Called when the current icon theme is switched or GTK+ detects that
	///< a change has occurred in the contents of the current icon theme.

/// @}
};

} // namespace Gtk

} // namespace Xfc

#endif // XFC_GTK_ICON_THEME_SIGNALS_HH

